/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.tools.id;

import com.efuture.pre.tools.redis.RedisTools;
import com.efuture.pre.utils.exceptions.PreException;

public class IDBuilder {
    private final String key = "pre.tool.idbuilder.id";
    private final long step = 1L;
    private RedisTools instance = null;

    public IDBuilder() {
        try {
            this.initInstance();
        }
        catch (Exception e) {
            throw new PreException("IDBuilder Exception:" + e.getMessage());
        }
    }

    public IDBuilder(String path) {
        try {
            this.initInstance(path);
        }
        catch (Exception e) {
            throw new PreException("IDBuilder Exception:" + e.getMessage());
        }
    }

    private void initInstance(String path) {
        if (null == this.instance) {
            this.instance = new RedisTools(path);
        }
    }

    private void initInstance() {
        if (null == this.instance) {
            this.instance = new RedisTools();
        }
    }

    public long generateId() {
        return this.generateId(this.key);
    }

    public long generateId(String key) {
        return this.instance.makeId(key);
    }

    public long generateId(String key, String field) {
        return this.instance.hincrBy(key, field, 1L);
    }

    public long generateId(String key, String field, int len) {
        long id = this.generateId(key, String.format("%s.%d", field, len));
        return id + this.getfixedLength(len);
    }

    private long getfixedLength(long len) {
        return (long)Math.pow(10.0, len - 1L);
    }
}

