/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.tools.id;

import com.efuture.pre.tools.id.KeyNextCode;
import com.efuture.pre.tools.redis.RedisTools;
import com.efuture.pre.utils.ConvertHelper;
import com.efuture.pre.utils.string.StringUtil;

public class IDGenerator {
    public static final String CONS_ID = "pre.atom.cons.id";
    public static final String ATOM_ID = "pre.atom.id";
    public static final String BiggestKeyValue_ATOM = "pre.id.atom";
    public static final String BiggestKeyValue_BILL = "pre.id.bill";

    public static Long generateAtomID(Long in_nrid, String in_flag, String in_vkey, String in_code) {
        if (in_nrid == null || StringUtil.isEmpty((String)in_flag) || StringUtil.isEmpty((String)in_vkey) || StringUtil.isEmpty((String)in_code)) {
            return null;
        }
        long nbfmt = 0L;
        long batomid = 0L;
        batomid = IDGenerator.getAtomId(in_nrid, nbfmt, in_flag, in_vkey, in_code);
        if (batomid > 0L) {
            return batomid;
        }
        long max_atomid = KeyNextCode.get(BiggestKeyValue_ATOM);
        if (max_atomid > 0L) {
            batomid = max_atomid;
            KeyNextCode.increase(BiggestKeyValue_ATOM, 1L);
        } else {
            batomid = 1000000000000000L;
            max_atomid = 1000000000000001L;
            KeyNextCode.increase(BiggestKeyValue_ATOM, max_atomid);
        }
        IDGenerator.creatAtomId(in_nrid, nbfmt, in_flag, in_vkey, in_code, batomid);
        return batomid;
    }

    public static long generateCustomerID(Long in_nrid, String in_code, String in_idtyp, String in_idno, String in_telno) {
        long max_atomid = 0L;
        String consflag = in_nrid + "." + in_code;
        String consflag1 = null;
        String VREFKEY = "CONS";
        long batomid = IDGenerator.getConsId(CONS_ID, VREFKEY, consflag);
        if (batomid > 0L) {
            return batomid;
        }
        if (in_idtyp.equals("70310")) {
            batomid = IDGenerator.getConsId(CONS_ID, VREFKEY, in_idno);
        }
        if (batomid > 0L) {
            IDGenerator.creatConsId(CONS_ID, consflag, VREFKEY, batomid);
            return batomid;
        }
        if (StringUtil.areNotEmpty((String[])new String[]{in_telno}) && !in_telno.equals("0")) {
            batomid = IDGenerator.getConsId(CONS_ID, VREFKEY, in_telno);
        }
        consflag1 = in_idtyp.equals("70310") && StringUtil.areNotEmpty((String[])new String[]{in_idno}) && !in_idno.equals("0") ? in_idno : in_telno;
        if (batomid > 0L) {
            IDGenerator.creatConsId(CONS_ID, VREFKEY, consflag, batomid);
        } else {
            max_atomid = KeyNextCode.get(BiggestKeyValue_ATOM);
            if (max_atomid > 0L) {
                batomid = max_atomid;
                KeyNextCode.increase(BiggestKeyValue_ATOM, 1L);
            } else {
                batomid = 1000000000000000L;
                max_atomid = 1000000000000001L;
                KeyNextCode.increase(BiggestKeyValue_ATOM, max_atomid);
            }
            IDGenerator.creatConsId(CONS_ID, VREFKEY, consflag, batomid);
            if (StringUtil.areNotEmpty((String[])new String[]{consflag1}) && !consflag1.equals("0")) {
                IDGenerator.creatConsId(CONS_ID, VREFKEY, consflag1, batomid);
            }
        }
        return batomid;
    }

    private static long getAtomId(long nrid, long nbfmt, String flag, String vkey, String code) {
        StringBuilder key = new StringBuilder();
        key.append(ATOM_ID);
        key.append(".");
        key.append(nrid);
        key.append(".");
        key.append(nbfmt);
        StringBuilder field = new StringBuilder();
        field.append(flag);
        field.append(".");
        field.append(vkey);
        field.append(".");
        field.append(code);
        String id = new RedisTools().hashGet(key.toString(), field.toString());
        if (StringUtil.isEmpty((String)id)) {
            return 0L;
        }
        return ConvertHelper.parseLong((String)id);
    }

    private static Long getConsId(String table, String flag, String code) {
        StringBuilder key = new StringBuilder();
        key.append(table);
        StringBuilder field = new StringBuilder();
        field.append("id.");
        field.append(flag);
        field.append(".");
        field.append(code);
        String id = new RedisTools().hashGet(key.toString(), field.toString());
        if (StringUtil.isEmpty((String)id)) {
            return 0L;
        }
        return ConvertHelper.parseLong((String)id);
    }

    private static void creatAtomId(long nrid, long nbfmt, String flag, String vkey, String code, long batomid) {
        StringBuilder key = new StringBuilder();
        key.append(ATOM_ID);
        key.append(".");
        key.append(nrid);
        key.append(".");
        key.append(nbfmt);
        StringBuilder field = new StringBuilder();
        field.append(flag);
        field.append(".");
        field.append(vkey);
        field.append(".");
        field.append(code);
        new RedisTools().hashSet(key.toString(), field.toString(), ConvertHelper.parseString((Object)batomid));
    }

    private static void creatConsId(String table, String flag, String code, long batomid) {
        StringBuilder key = new StringBuilder();
        key.append(table);
        StringBuilder field = new StringBuilder();
        field.append("id.");
        field.append(flag);
        field.append(".");
        field.append(code);
        new RedisTools().hashSet(key.toString(), field.toString(), ConvertHelper.parseString((Object)batomid));
    }
}

