/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.tools.log;

import com.efuture.pre.tools.log.Logger;
import com.efuture.pre.utils.ConfigHelper;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class LoggerAdapter
implements Logger {
    private org.slf4j.Logger instance = null;
    private String tag = "LoggerAdapter";
    private String file = "log4j.properties";
    private String key_tag = "log4j.tag";

    public LoggerAdapter() {
        this("LoggerAdapter");
    }

    public LoggerAdapter(Class<?> clazz) {
        this(clazz.getName());
    }

    public LoggerAdapter(String name) {
        this.instance = LoggerFactory.getLogger((String)name);
        this.init();
    }

    private void init() {
        try {
            this.tag = ConfigHelper.getConfigProperties((String)this.file).getProperty(this.key_tag);
            if (null == this.tag) {
                this.tag = "tools-logger";
            }
        }
        catch (Exception e) {
            this.instance.warn("[tools-logger] \u65e0\u6cd5\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6{}\u4fe1\u606f{}", (Object)this.file, (Object)this.key_tag);
        }
    }

    public String getName() {
        return this.instance.getName();
    }

    public boolean isTraceEnabled() {
        return this.instance.isTraceEnabled();
    }

    public void trace(String msg) {
        this.instance.trace("[" + this.tag + "] " + msg);
    }

    @Override
    public void trace(String tag, String msg) {
        this.instance.trace("[" + tag + "] " + msg);
    }

    public void trace(String format, Object arg) {
        this.instance.trace("[" + this.tag + "] " + format, arg);
    }

    @Override
    public void trace(String tag, String format, Object arg) {
        this.instance.trace("[" + tag + "] " + format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.instance.trace("[" + this.tag + "] " + format, arg1, arg2);
    }

    @Override
    public void trace(String tag, String format, Object arg1, Object arg2) {
        this.instance.trace("[" + tag + "] " + format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.instance.trace("[" + this.tag + "] " + format, arguments);
    }

    @Override
    public void trace(String tag, String format, Object ... arguments) {
        this.instance.trace("[" + tag + "] " + format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.instance.trace("[" + this.tag + "] " + msg, t);
    }

    @Override
    public void trace(String tag, String msg, Throwable t) {
        this.instance.trace("[" + tag + "] " + msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.instance.isTraceEnabled();
    }

    public void trace(Marker marker, String msg) {
        this.instance.trace(marker, "[" + this.tag + "] " + msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.instance.trace(marker, "[" + this.tag + "] " + format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.instance.trace(marker, "[" + this.tag + "] " + format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.instance.trace(marker, "[" + this.tag + "] " + format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.instance.trace(marker, "[" + this.tag + "] " + msg, t);
    }

    public boolean isDebugEnabled() {
        return this.instance.isDebugEnabled();
    }

    public void debug(String msg) {
        this.instance.debug("[" + this.tag + "] " + msg);
    }

    @Override
    public void debug(String tag, String msg) {
        this.instance.debug("[" + tag + "] " + msg);
    }

    public void debug(String format, Object arg) {
        this.instance.debug("[" + this.tag + "] " + format, arg);
    }

    @Override
    public void debug(String tag, String format, Object arg) {
        this.instance.debug("[" + tag + "] " + format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.instance.debug("[" + this.tag + "] " + format, arg1, arg2);
    }

    @Override
    public void debug(String tag, String format, Object arg1, Object arg2) {
        this.instance.debug("[" + tag + "] " + format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.instance.debug("[" + this.tag + "] " + format, arguments);
    }

    @Override
    public void debug(String tag, String format, Object ... arguments) {
        this.instance.debug("[" + tag + "] " + format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.instance.debug("[" + this.tag + "] " + msg, t);
    }

    @Override
    public void debug(String tag, String msg, Throwable t) {
        this.instance.debug("[" + tag + "] " + msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.instance.isDebugEnabled();
    }

    public void debug(Marker marker, String msg) {
        this.instance.debug(marker, "[" + this.tag + "] " + msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.instance.debug(marker, "[" + this.tag + "] " + format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.instance.debug(marker, "[" + this.tag + "] " + format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.instance.debug(marker, "[" + this.tag + "] " + format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.instance.debug(marker, "[" + this.tag + "] " + msg, t);
    }

    public boolean isInfoEnabled() {
        return false;
    }

    public void info(String msg) {
        this.instance.info("[{}] {}", (Object)this.tag, (Object)msg);
    }

    @Override
    public void info(String tag, String msg) {
        this.instance.info("[{}] {}", (Object)tag, (Object)msg);
    }

    public void info(String format, Object arg) {
        this.instance.info("[" + this.tag + "] " + format, arg);
    }

    @Override
    public void info(String tag, String format, Object arg) {
        this.instance.info("[" + tag + "] " + format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.instance.info("[" + this.tag + "] " + format, arg1, arg2);
    }

    @Override
    public void info(String tag, String format, Object arg1, Object arg2) {
        this.instance.info("[" + tag + "] " + format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.instance.info("[" + this.tag + "] " + format, arguments);
    }

    @Override
    public void info(String tag, String format, Object ... arguments) {
        this.instance.info("[" + tag + "] " + format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.instance.info("[" + this.tag + "] " + msg, t);
    }

    @Override
    public void info(String tag, String msg, Throwable t) {
        this.instance.info("[" + tag + "] " + msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.instance.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.instance.info(marker, "[" + this.tag + "]" + msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.instance.info(marker, "[" + this.tag + "]" + format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.instance.info(marker, "[" + this.tag + "]" + format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.instance.info(marker, "[" + this.tag + "]" + format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.instance.info(marker, "[" + this.tag + "]" + msg, t);
    }

    public boolean isWarnEnabled() {
        return this.instance.isWarnEnabled();
    }

    public void warn(String msg) {
        this.instance.warn("[" + this.tag + "] " + msg);
    }

    @Override
    public void warn(String tag, String msg) {
        this.instance.warn("[" + tag + "] " + msg);
    }

    public void warn(String format, Object arg) {
        this.instance.warn("[" + this.tag + "] " + format, arg);
    }

    @Override
    public void warn(String tag, String format, Object arg) {
        this.instance.warn("[" + tag + "] " + format, arg);
    }

    public void warn(String format, Object ... arguments) {
        this.instance.warn("[" + this.tag + "] " + format, arguments);
    }

    @Override
    public void warn(String tag, String format, Object ... arguments) {
        this.instance.warn("[" + tag + "] " + format, arguments);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.instance.warn("[" + this.tag + "] " + format, arg1, arg2);
    }

    @Override
    public void warn(String tag, String format, Object arg1, Object arg2) {
        this.instance.warn("[" + tag + "] " + format, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        this.instance.warn("[" + this.tag + "] " + msg, t);
    }

    @Override
    public void warn(String tag, String msg, Throwable t) {
        this.instance.warn("[" + tag + "] " + msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.instance.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.instance.warn(marker, "[" + this.tag + "] " + msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.instance.warn(marker, "[" + this.tag + "] " + format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.instance.warn(marker, "[" + this.tag + "] " + format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.instance.warn(marker, "[" + this.tag + "] " + format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.instance.warn(marker, "[" + this.tag + "] " + msg, t);
    }

    public boolean isErrorEnabled() {
        return this.instance.isErrorEnabled();
    }

    public void error(String msg) {
        this.instance.error("[{}] {}", (Object)this.tag, (Object)msg);
    }

    @Override
    public void error(String tag, String msg) {
        this.instance.error("[{}] {}", (Object)tag, (Object)msg);
    }

    public void error(String format, Object arg) {
        this.instance.error("[" + this.tag + "] " + format, arg);
    }

    @Override
    public void error(String tag, String format, Object arg) {
        this.instance.error("[" + tag + "] " + format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.instance.error("[" + this.tag + "] " + format, arg1, arg2);
    }

    @Override
    public void error(String tag, String format, Object arg1, Object arg2) {
        this.instance.error("[" + tag + "] " + format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.instance.error("[" + this.tag + "] " + format, arguments);
    }

    @Override
    public void error(String tag, String format, Object ... arguments) {
        this.instance.error("[" + tag + "] " + format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.instance.error("[" + this.tag + "] " + msg, t);
    }

    @Override
    public void error(String tag, String msg, Throwable t) {
        this.instance.error("[" + tag + "] " + msg, t);
    }

    @Override
    public void error(Throwable t) {
        this.error("", t);
    }

    @Override
    public void error(Throwable t, String tag) {
        this.error("[" + tag + "] ", t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.instance.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.instance.error(marker, "[" + this.tag + "] " + msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.instance.error(marker, "[" + this.tag + "] " + format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.instance.error(marker, "[" + this.tag + "] " + format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.instance.error(marker, "[" + this.tag + "] " + format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.instance.error(marker, "[" + this.tag + "] " + msg, t);
    }
}

