/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.tools.mail;

import com.efuture.pre.tools.mail.ByteArrayDataSource;
import com.efuture.pre.tools.mail.MailInformation;
import com.efuture.pre.tools.mail.SmtpAuthenticator;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import sun.misc.BASE64Encoder;

public class Email {
    public static int send(MailInformation mailInformation) throws MessagingException, UnsupportedEncodingException {
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.host", mailInformation.getSmtpServer());
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new SmtpAuthenticator(mailInformation.getUsername(), mailInformation.getPassword()));
        MimeMessage mimeMessage = mailInformation.getImagePath() != null && !"".equals(mailInformation.getImagePath()) ? Email.getMimeObject(session, (Address)new InternetAddress(mailInformation.getUsername(), mailInformation.getFromMailAddress()), (Address)new InternetAddress(mailInformation.getToMailAddress()), mailInformation.getItem(), mailInformation.getContent(), mailInformation.getImagePath()) : Email.getMimeObject(session, (Address)new InternetAddress(mailInformation.getUsername(), mailInformation.getFromMailAddress()), (Address)new InternetAddress(mailInformation.getToMailAddress()), mailInformation.getItem(), mailInformation.getContent());
        Transport.send((Message)mimeMessage);
        return 1;
    }

    public static int send(String username, String password, String smtpServer, String fromMailAddress, String toMailAddress, String item, String content) throws MessagingException, UnsupportedEncodingException {
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.host", smtpServer);
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new SmtpAuthenticator(username, password));
        MimeMessage mimeMessage = Email.getMimeObject(session, (Address)new InternetAddress(username, fromMailAddress), (Address)new InternetAddress(toMailAddress), item, content);
        Transport.send((Message)mimeMessage);
        return 1;
    }

    public static int send(String username, String password, String smtpServer, String fromMailAddress, String toMailAddress, String item, String content, String path) throws MessagingException, UnsupportedEncodingException {
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.host", smtpServer);
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new SmtpAuthenticator(username, password));
        MimeMessage mimeMessage = Email.getMimeObject(session, (Address)new InternetAddress(username, fromMailAddress), (Address)new InternetAddress(toMailAddress), content, content, path);
        Transport.send((Message)mimeMessage);
        return 1;
    }

    private static MimeMessage getMimeObject(Session session, Address fromMailAddress, Address toMailAddress, String item, String content, String path) throws MessagingException {
        MimeMessage mimeMessage = null;
        mimeMessage = Email.setPublicMailInfo(session, fromMailAddress, toMailAddress, item);
        MimeMultipart multipart = new MimeMultipart("related");
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setDataHandler(new DataHandler((Object)content, "text/html;charset=UTF-8"));
        MimeBodyPart img = Email.getImageBody(path);
        multipart.addBodyPart((BodyPart)img);
        multipart.addBodyPart((BodyPart)bodyPart);
        mimeMessage.setContent((Multipart)multipart);
        return mimeMessage;
    }

    private static MimeMessage getMimeObject(Session session, Address fromMailAddress, Address toMailAddress, String item, String content) throws MessagingException {
        MimeMessage mimeMessage = null;
        mimeMessage = Email.setPublicMailInfo(session, fromMailAddress, toMailAddress, item);
        MimeMultipart multipart = new MimeMultipart("related");
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setDataHandler(new DataHandler((Object)content, "text/html;charset=UTF-8"));
        multipart.addBodyPart((BodyPart)bodyPart);
        mimeMessage.setContent((Multipart)multipart);
        return mimeMessage;
    }

    private static MimeMessage setPublicMailInfo(Session session, Address fromMailAddress, Address toMailAddress, String item) throws MessagingException {
        MimeMessage mimeMessage = null;
        mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom(fromMailAddress);
        mimeMessage.setRecipient(Message.RecipientType.BCC, toMailAddress);
        mimeMessage.setSubject(item);
        mimeMessage.setSentDate(new Date());
        return mimeMessage;
    }

    private static MimeBodyPart getImageBody(String path) throws MessagingException {
        MimeBodyPart img = null;
        img = new MimeBodyPart();
        DataHandler dh = new DataHandler((DataSource)new FileDataSource(path));
        img.setDataHandler(dh);
        img.setContentID("a");
        return img;
    }

    private BodyPart ordinaryAttachment(String filePath) throws MessagingException {
        MimeBodyPart attachBodyPart = null;
        attachBodyPart = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(filePath);
        attachBodyPart.setDataHandler(new DataHandler((DataSource)fds));
        attachBodyPart.setFileName("=?GBK?B?" + new BASE64Encoder().encode(fds.getName().getBytes()) + "?=");
        return attachBodyPart;
    }

    private MimeBodyPart attachmentIcon(String imagePath) throws MessagingException {
        MimeBodyPart imgBodyPart = null;
        imgBodyPart = new MimeBodyPart();
        byte[] bytes = Email.readFile(imagePath);
        ByteArrayDataSource fileds = new ByteArrayDataSource(bytes, "application/octet-stream");
        imgBodyPart.setDataHandler(new DataHandler((DataSource)fileds));
        imgBodyPart.setFileName("girl.jpg");
        imgBodyPart.setHeader("Content-ID", "<img1></img1>");
        return imgBodyPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String file) {
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            int bytesRead;
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[0x100000];
            while ((bytesRead = fis.read(buffer)) != -1) {
                bos.write(buffer, 0, bytesRead);
                Arrays.fill(buffer, (byte)0);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bos.toByteArray();
    }
}

