/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.tools.redis;

import com.efuture.pre.tools.redis.RedisUtil;
import com.efuture.pre.utils.ConfigHelper;
import com.efuture.pre.utils.ConvertHelper;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedisPool;

public class RedisTools
extends RedisUtil {
    private Logger logger = Logger.getLogger(RedisTools.class);
    private final String key_host = "redis.host";
    private final String key_port = "redis.port";
    private final String key_timeout = "redis.timeout";
    private final String key_max_active = "redis.maxActive";
    private final String key_testOnBorrow = "redis.testOnBorrow";
    private final String key_max_idle = "redis.maxIdle";
    private final String key_max_wait = "redis.maxWait";

    public RedisTools(String properties) {
        Properties pro = ConfigHelper.getConfigProperties((String)properties);
        JedisPoolConfig jp = new JedisPoolConfig();
        jp.setMaxActive(ConvertHelper.parseInt((Object)pro.get("redis.maxActive")));
        jp.setMaxIdle(ConvertHelper.parseInt((Object)pro.get("redis.maxIdle")));
        jp.setMaxWait((long)ConvertHelper.parseInt((Object)pro.get("redis.maxWait")));
        jp.setTestOnBorrow(ConvertHelper.parseBoolean((String)ConvertHelper.parseString((Object)pro.get("redis.testOnBorrow"))));
        String url = ConvertHelper.parseString((Object)pro.get("redis.host"));
        int port = ConvertHelper.parseInt((Object)pro.get("redis.port"));
        int timeout = ConvertHelper.parseInt((Object)pro.get("redis.timeout"));
        this.logger.info((Object)String.format("RedisTools MaxActive:%d MaxIdle:%d MaxWait:%d", jp.getMaxActive(), jp.getMaxIdle(), jp.getMaxWait()));
        JedisShardInfo jsi = new JedisShardInfo(url, port);
        this.logger.info((Object)String.format("RedisTools Host:%s Port:%d Timeout:%d", jsi.getHost(), jsi.getPort(), jsi.getTimeout()));
        ArrayList<JedisShardInfo> list = new ArrayList<JedisShardInfo>();
        list.add(jsi);
        ShardedJedisPool sjp = new ShardedJedisPool((GenericObjectPool.Config)jp, list);
        this.setShardedJedisPool(sjp);
    }

    public RedisTools() {
        this("conf/redis.properties");
    }
}

