/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.tools.redis;

import com.efuture.pre.tools.redis.RedisLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.Transaction;

public class RedisUtil {
    private ShardedJedisPool shardedJedisPool;

    public long delKeysLike(final String likeKey) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                Collection jedisC = this.jedis.getAllShards();
                Iterator iter = jedisC.iterator();
                long count = 0L;
                while (iter.hasNext()) {
                    Jedis _jedis = (Jedis)iter.next();
                    Set keys = _jedis.keys(likeKey + "*");
                    count += _jedis.del(keys.toArray(new String[keys.size()])).longValue();
                }
                return count;
            }
        }.getResult();
    }

    public Long delKey(final String key) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                return this.jedis.del(key);
            }
        }.getResult();
    }

    public Long delKeys(final String[] keys) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                Collection jedisC = this.jedis.getAllShards();
                Iterator iter = jedisC.iterator();
                long count = 0L;
                while (iter.hasNext()) {
                    Jedis _jedis = (Jedis)iter.next();
                    count += _jedis.del(keys).longValue();
                }
                return count;
            }
        }.getResult();
    }

    public Long expire(final String key, final int expire) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                return this.jedis.expire(key, expire);
            }
        }.getResult();
    }

    public long makeId(final String key) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                long id = this.jedis.incr(key);
                if (id + 75807L >= Long.MAX_VALUE) {
                    this.jedis.getSet(key, "0");
                }
                return id;
            }
        }.getResult();
    }

    public String setString(final String key, final String value) {
        return (String)new Executor<String>(this.shardedJedisPool){

            @Override
            String execute() {
                return this.jedis.set(key, value);
            }
        }.getResult();
    }

    public String setString(final String key, final String value, final int expire) {
        return (String)new Executor<String>(this.shardedJedisPool){

            @Override
            String execute() {
                return this.jedis.setex(key, expire, value);
            }
        }.getResult();
    }

    public Long setStringIfNotExists(final String key, final String value) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                return this.jedis.setnx(key, value);
            }
        }.getResult();
    }

    public String getString(final String key) {
        return (String)new Executor<String>(this.shardedJedisPool){

            @Override
            String execute() {
                return this.jedis.get(key);
            }
        }.getResult();
    }

    public List<Object> batchSetString(final List<Pair<String, String>> pairs) {
        return (List)new Executor<List<Object>>(this.shardedJedisPool){

            @Override
            List<Object> execute() {
                ShardedJedisPipeline pipeline = this.jedis.pipelined();
                for (Pair pair : pairs) {
                    pipeline.set((String)pair.getKey(), (String)pair.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public List<String> batchGetString(final String[] keys) {
        return (List)new Executor<List<String>>(this.shardedJedisPool){

            @Override
            List<String> execute() {
                ShardedJedisPipeline pipeline = this.jedis.pipelined();
                ArrayList<String> result = new ArrayList<String>(keys.length);
                ArrayList<Response> responses = new ArrayList<Response>(keys.length);
                for (String key : keys) {
                    responses.add(pipeline.get(key));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((String)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public Long hashSet(final String key, final String field, final String value) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                return this.jedis.hset(key, field, value);
            }
        }.getResult();
    }

    public Long hashSet(final String key, final String field, final String value, final int expire) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                Pipeline pipeline = ((Jedis)this.jedis.getShard(key)).pipelined();
                Response result = pipeline.hset(key, field, value);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (Long)result.get();
            }
        }.getResult();
    }

    public String hashGet(final String key, final String field) {
        return (String)new Executor<String>(this.shardedJedisPool){

            @Override
            String execute() {
                return this.jedis.hget(key, field);
            }
        }.getResult();
    }

    public String hashGet(final String key, final String field, final int expire) {
        return (String)new Executor<String>(this.shardedJedisPool){

            @Override
            String execute() {
                Pipeline pipeline = ((Jedis)this.jedis.getShard(key)).pipelined();
                Response result = pipeline.hget(key, field);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (String)result.get();
            }
        }.getResult();
    }

    public String hashMultipleSet(final String key, final Map<String, String> hash) {
        return (String)new Executor<String>(this.shardedJedisPool){

            @Override
            String execute() {
                return this.jedis.hmset(key, hash);
            }
        }.getResult();
    }

    public String hashMultipleSet(final String key, final Map<String, String> hash, final int expire) {
        return (String)new Executor<String>(this.shardedJedisPool){

            @Override
            String execute() {
                Pipeline pipeline = ((Jedis)this.jedis.getShard(key)).pipelined();
                Response result = pipeline.hmset(key, hash);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (String)result.get();
            }
        }.getResult();
    }

    public List<String> hashMultipleGet(final String key, final String ... fields) {
        return (List)new Executor<List<String>>(this.shardedJedisPool){

            @Override
            List<String> execute() {
                return this.jedis.hmget(key, fields);
            }
        }.getResult();
    }

    public List<String> hashMultipleGet(final String key, final int expire, final String ... fields) {
        return (List)new Executor<List<String>>(this.shardedJedisPool){

            @Override
            List<String> execute() {
                Pipeline pipeline = ((Jedis)this.jedis.getShard(key)).pipelined();
                Response result = pipeline.hmget(key, fields);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (List)result.get();
            }
        }.getResult();
    }

    public List<Object> batchHashMultipleSet(final List<Pair<String, Map<String, String>>> pairs) {
        return (List)new Executor<List<Object>>(this.shardedJedisPool){

            @Override
            List<Object> execute() {
                ShardedJedisPipeline pipeline = this.jedis.pipelined();
                for (Pair pair : pairs) {
                    pipeline.hmset((String)pair.getKey(), (Map)pair.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public List<Object> batchHashMultipleSet(final Map<String, Map<String, String>> data) {
        return (List)new Executor<List<Object>>(this.shardedJedisPool){

            @Override
            List<Object> execute() {
                ShardedJedisPipeline pipeline = this.jedis.pipelined();
                for (Map.Entry iter : data.entrySet()) {
                    pipeline.hmset((String)iter.getKey(), (Map)iter.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public List<List<String>> batchHashMultipleGet(final List<Pair<String, String[]>> pairs) {
        return (List)new Executor<List<List<String>>>(this.shardedJedisPool){

            @Override
            List<List<String>> execute() {
                ShardedJedisPipeline pipeline = this.jedis.pipelined();
                ArrayList<List<String>> result = new ArrayList<List<String>>(pairs.size());
                ArrayList<Response> responses = new ArrayList<Response>(pairs.size());
                for (Pair pair : pairs) {
                    responses.add(pipeline.hmget((String)pair.getKey(), (String[])pair.getValue()));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((List<String>)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public Map<String, String> hashGetAll(final String key) {
        return (Map)new Executor<Map<String, String>>(this.shardedJedisPool){

            @Override
            Map<String, String> execute() {
                return this.jedis.hgetAll(key);
            }
        }.getResult();
    }

    public Map<String, String> hashGetAll(final String key, final int expire) {
        return (Map)new Executor<Map<String, String>>(this.shardedJedisPool){

            @Override
            Map<String, String> execute() {
                Pipeline pipeline = ((Jedis)this.jedis.getShard(key)).pipelined();
                Response result = pipeline.hgetAll(key);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (Map)result.get();
            }
        }.getResult();
    }

    public List<Map<String, String>> batchHashGetAll(final String ... keys) {
        return (List)new Executor<List<Map<String, String>>>(this.shardedJedisPool){

            @Override
            List<Map<String, String>> execute() {
                ShardedJedisPipeline pipeline = this.jedis.pipelined();
                ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(keys.length);
                ArrayList<Response> responses = new ArrayList<Response>(keys.length);
                for (String key : keys) {
                    responses.add(pipeline.hgetAll(key));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((Map<String, String>)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public Map<String, Map<String, String>> batchHashGetAllForMap(final String ... keys) {
        return (Map)new Executor<Map<String, Map<String, String>>>(this.shardedJedisPool){

            @Override
            Map<String, Map<String, String>> execute() {
                ShardedJedisPipeline pipeline = this.jedis.pipelined();
                int capacity = 1;
                while ((int)((double)capacity * 0.75) <= keys.length) {
                    capacity <<= 1;
                }
                HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(capacity);
                ArrayList<Response> responses = new ArrayList<Response>(keys.length);
                for (String key : keys) {
                    responses.add(pipeline.hgetAll(key));
                }
                pipeline.sync();
                for (int i = 0; i < keys.length; ++i) {
                    result.put(keys[i], (Map<String, String>)((Response)responses.get(i)).get());
                }
                return result;
            }
        }.getResult();
    }

    public Long listPushTail(final String key, final String ... values) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                return this.jedis.rpush(key, values);
            }
        }.getResult();
    }

    public Long listPushHeadAndTrim(final String key, final String value, final long size) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                Pipeline pipeline = ((Jedis)this.jedis.getShard(key)).pipelined();
                Response result = pipeline.lpush(key, new String[]{value});
                pipeline.ltrim(key, 0L, size - 1L);
                pipeline.sync();
                return (Long)result.get();
            }
        }.getResult();
    }

    public void batchListPushTail(final String key, final String[] values, final boolean delOld) {
        new Executor<Object>(this.shardedJedisPool){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Object execute() {
                if (delOld) {
                    RedisLock lock = new RedisLock(key, this.shardedJedisPool);
                    lock.lock();
                    try {
                        Pipeline pipeline = ((Jedis)this.jedis.getShard(key)).pipelined();
                        pipeline.del(key);
                        for (String value : values) {
                            pipeline.rpush(key, new String[]{value});
                        }
                        pipeline.sync();
                    }
                    finally {
                        lock.unlock();
                    }
                } else {
                    this.jedis.rpush(key, values);
                }
                return null;
            }
        }.getResult();
    }

    public Object updateListInTransaction(final String key, final List<String> values) {
        return new Executor<Object>(this.shardedJedisPool){

            @Override
            Object execute() {
                Transaction transaction = ((Jedis)this.jedis.getShard(key)).multi();
                transaction.del(key);
                for (String value : values) {
                    transaction.rpush(key, new String[]{value});
                }
                transaction.exec();
                return null;
            }
        }.getResult();
    }

    public Long insertListIfNotExists(final String key, final String[] values) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Long execute() {
                RedisLock lock = new RedisLock(key, this.shardedJedisPool);
                lock.lock();
                try {
                    if (!this.jedis.exists(key).booleanValue()) {
                        Long l = this.jedis.rpush(key, values);
                        return l;
                    }
                }
                finally {
                    lock.unlock();
                }
                return 0L;
            }
        }.getResult();
    }

    public List<String> listGetAll(final String key) {
        return (List)new Executor<List<String>>(this.shardedJedisPool){

            @Override
            List<String> execute() {
                return this.jedis.lrange(key, 0L, -1L);
            }
        }.getResult();
    }

    public List<String> listRange(final String key, final long beginIndex, final long endIndex) {
        return (List)new Executor<List<String>>(this.shardedJedisPool){

            @Override
            List<String> execute() {
                return this.jedis.lrange(key, beginIndex, endIndex - 1L);
            }
        }.getResult();
    }

    public Map<String, List<String>> batchGetAllList(final List<String> keys) {
        return (Map)new Executor<Map<String, List<String>>>(this.shardedJedisPool){

            @Override
            Map<String, List<String>> execute() {
                ShardedJedisPipeline pipeline = this.jedis.pipelined();
                HashMap<String, List<String>> result = new HashMap<String, List<String>>();
                ArrayList<Response> responses = new ArrayList<Response>(keys.size());
                for (String key : keys) {
                    responses.add(pipeline.lrange(key, 0L, -1L));
                }
                pipeline.sync();
                for (int i = 0; i < keys.size(); ++i) {
                    result.put((String)keys.get(i), (List<String>)((Response)responses.get(i)).get());
                }
                return result;
            }
        }.getResult();
    }

    public Long hincrBy(final String key, final String field, final long value) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                return this.jedis.hincrBy(key, field, value);
            }
        }.getResult();
    }

    public Long hlen(final String key) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                return this.jedis.hlen(key);
            }
        }.getResult();
    }

    public Long publish(final String channel, final String message) {
        return (Long)new Executor<Long>(this.shardedJedisPool){

            @Override
            Long execute() {
                Jedis _jedis = (Jedis)this.jedis.getShard(channel);
                return _jedis.publish(channel, message);
            }
        }.getResult();
    }

    public void subscribe(final JedisPubSub jedisPubSub, final String channel) {
        new Executor<Object>(this.shardedJedisPool){

            @Override
            Object execute() {
                Jedis _jedis = (Jedis)this.jedis.getShard(channel);
                _jedis.subscribe(jedisPubSub, new String[]{channel});
                return null;
            }
        }.getResult();
    }

    public void unSubscribe(JedisPubSub jedisPubSub) {
        jedisPubSub.unsubscribe();
    }

    public void setShardedJedisPool(ShardedJedisPool shardedJedisPool) {
        this.shardedJedisPool = shardedJedisPool;
    }

    public <K, V> Pair<K, V> makePair(K key, V value) {
        return new Pair<K, V>(key, value);
    }

    public class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }

    abstract class Executor<T> {
        ShardedJedis jedis = null;
        ShardedJedisPool shardedJedisPool = null;

        public Executor(ShardedJedisPool shardedJedisPool) {
            this.shardedJedisPool = shardedJedisPool;
            this.jedis = (ShardedJedis)this.shardedJedisPool.getResource();
        }

        abstract T execute();

        public T getResult() {
            T result = null;
            try {
                result = this.execute();
            }
            catch (Throwable e) {
                throw new RuntimeException("Redis execute exception", e);
            }
            finally {
                if (this.jedis != null) {
                    this.shardedJedisPool.returnResource((Object)this.jedis);
                }
            }
            return result;
        }
    }
}

