/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.tools.sql;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Map;

public abstract class SQLBuilder {
    public static <T> String builder(String inertPrefix, T obj) throws IllegalArgumentException, IntrospectionException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (obj instanceof Map) {
            return SQLBuilder.builderSQL(inertPrefix, (Map)obj);
        }
        return SQLBuilder.builderSQL(inertPrefix, obj);
    }

    public static String builderSQL(String inertPrefix, Map<String, Object> params) {
        StringBuffer nameBuffer = new StringBuffer("(");
        StringBuffer valueBuffer = new StringBuffer("(");
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            nameBuffer.append(name);
            if (value instanceof String) {
                valueBuffer.append("'").append(String.valueOf(value)).append("'");
            } else if (value instanceof Double) {
                valueBuffer.append(Double.parseDouble(String.valueOf(value)));
            } else if (value instanceof Long) {
                valueBuffer.append(Long.parseLong(String.valueOf(value)));
            } else if (value instanceof Integer) {
                valueBuffer.append(Integer.parseInt(String.valueOf(value)));
            } else if (value instanceof BigDecimal) {
                valueBuffer.append(new BigDecimal(String.valueOf(value)).toPlainString());
            } else {
                valueBuffer.append(String.valueOf(value));
            }
            nameBuffer.append(",");
            valueBuffer.append(",");
        }
        nameBuffer.replace(nameBuffer.length() - 1, nameBuffer.length(), ")");
        valueBuffer.replace(valueBuffer.length() - 1, valueBuffer.length(), ")");
        return new StringBuffer(inertPrefix).append(nameBuffer).append(" values").append(valueBuffer).toString();
    }

    public static <T> String builderSQL(String inertPrefix, T obj) throws IntrospectionException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PropertyDescriptor[] propertyDescriptors;
        StringBuffer nameBuffer = new StringBuffer("(");
        StringBuffer valueBuffer = new StringBuffer("(");
        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            String propertyName = propertyDescriptor.getName();
            if ("class".equals(propertyName)) continue;
            nameBuffer.append(propertyName);
            Class<?> propertyType = propertyDescriptor.getPropertyType();
            Object value = propertyDescriptor.getReadMethod().invoke(obj, new Object[0]);
            if (propertyType == String.class) {
                valueBuffer.append("'").append(String.valueOf(value)).append("'");
            } else if (propertyType == Double.TYPE) {
                valueBuffer.append(Double.parseDouble(String.valueOf(value)));
            } else if (propertyType == Double.class) {
                valueBuffer.append(Double.parseDouble(String.valueOf(value)));
            } else if (propertyType == Long.TYPE) {
                valueBuffer.append(Long.parseLong(String.valueOf(value)));
            } else if (propertyType == Long.class) {
                valueBuffer.append(Long.parseLong(String.valueOf(value)));
            } else if (propertyType == Integer.TYPE) {
                valueBuffer.append(Integer.parseInt(String.valueOf(value)));
            } else if (propertyType == Integer.class) {
                valueBuffer.append(Integer.parseInt(String.valueOf(value)));
            } else if (propertyType == BigDecimal.class) {
                valueBuffer.append(new BigDecimal(String.valueOf(value)).toPlainString());
            } else {
                valueBuffer.append(String.valueOf(value));
            }
            nameBuffer.append(",");
            valueBuffer.append(",");
        }
        nameBuffer.replace(nameBuffer.length() - 1, nameBuffer.length(), ")");
        valueBuffer.replace(valueBuffer.length() - 1, valueBuffer.length(), ")");
        return new StringBuffer(inertPrefix).append(nameBuffer).append(" values").append(valueBuffer).toString();
    }
}

