/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.tools.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public abstract class ZXingHelper {
    private static final String UTF_8 = "UTF-8";

    public static BufferedImage toBufferedImage(String content, int width, int height, int margin) {
        return MatrixToImageWriter.toBufferedImage((BitMatrix)ZXingHelper.createBitMatrix(content, width, height, margin));
    }

    public static void writeToStream(OutputStream out, String content, String imgFormat, int width, int height, int margin) throws IOException {
        MatrixToImageWriter.writeToStream((BitMatrix)ZXingHelper.createBitMatrix(content, width, height, margin), (String)imgFormat, (OutputStream)out);
    }

    public static void writeToFile(File file, String content, String imgFormat, int width, int height, int margin) throws IOException {
        MatrixToImageWriter.writeToFile((BitMatrix)ZXingHelper.createBitMatrix(content, width, height, margin), (String)imgFormat, (File)file);
    }

    private static BitMatrix createBitMatrix(String content, int width, int height, int margin) {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, UTF_8);
        hints.put(EncodeHintType.MARGIN, margin);
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        BitMatrix matrix = null;
        try {
            matrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        return matrix;
    }
}

