/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.efuture.commonkit.ManipulatePrecision;
import com.efuture.vo.InputAllVO;
import com.efuture.vo.InputSingleVO;
import com.efuture.vo.ModeDetailsVo;
import com.shiji.base.bean.Code;
import com.shiji.base.bean.ServiceSession;
import com.shiji.base.model.CacheModel;
import com.shiji.base.model.RespBase;
import com.shiji.base.model.ResqVo;
import com.shiji.base.model.pos.Goods;
import com.shiji.base.model.pos.SysParaInfo;
import com.shiji.base.poslogic.PosLogicCompoment;
import com.shiji.base.poslogic.PosLogicServiceImpl;
import com.shiji.base.util.CastUtil;
import com.shiji.base.util.ModeDetailsUtils;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ManualDiscountApi {
    public RespBase<ResqVo> disc(ServiceSession session, InputAllVO inputAllVO) {
        Double discountRate = inputAllVO.getDiscountRate();
        if (inputAllVO.getMode().equals("1")) {
            discountRate = Double.valueOf(100.0) - discountRate;
        } else if (inputAllVO.getMode().equals("0")) {
            // empty if block
        }
        if (discountRate == null) {
            return Code.CODE_30030.getRespBase(new Object[]{"\u6298\u6263\u7387\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String accreditNo = inputAllVO.getAccreditNo();
        CacheModel cacheModel = inputAllVO.getResqVO().getCacheModel();
        cacheModel.setCalcResult(0);
        if (cacheModel == null) {
            return Code.CODE_30030.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355"});
        }
        if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
            return Code.CODE_30030.getRespBase(new Object[]{"\u8ba2\u5355\u4e3a\u5370\u82b1\u6362\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c"});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return Code.CODE_30030.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1"});
        }
        if (null == accreditNo || "".equals(accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (cacheModel.getCurGrant().getPrivzpzkl() < 0.0) {
            return Code.CODE_30030.getRespBase(new Object[]{"\u5f53\u524d\u6388\u6743\u4eba\u5458\u4e0d\u5141\u8bb8\u6574\u5355\u6253\u6298"});
        }
        ModeDetailsVo modeDetailsVo = ModeDetailsUtils.geteModeDetails((String)session.getMode(), (String)cacheModel.getOrder().getShopCode(), (String)cacheModel.getOrder().getTerminalNo());
        double oldAmount = cacheModel.getOrder().getOughtPay();
        double tempZzr = cacheModel.getOrder().getTempZzr();
        cacheModel = PosLogicCompoment.removeZzr((CacheModel)cacheModel);
        if (-1 == (cacheModel = PosLogicServiceImpl.CalcOrderRebateByRateBeforeOrder((CacheModel)cacheModel, (String)accreditNo, (double)discountRate, (SysParaInfo)modeDetailsVo.getSysparainfo())).getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)inputAllVO.getResqVO());
        }
        if (cacheModel == null || cacheModel.getGoodsList() == null || cacheModel.getOrder() == null) {
            return Code.CODE_30030.getRespBase(new Object[]{"\u6574\u5355\u6298\u6263\u8c03\u7528\u8ba1\u7b97\u65b9\u6cd5,\u6ca1\u6709\u83b7\u5f97\u6709\u6548CacheModel"});
        }
        if (tempZzr != 0.0) {
            cacheModel = PosLogicServiceImpl.CalcOrderRebateByAmountBeforeOrder((CacheModel)cacheModel, (String)cacheModel.getCurGrant().getGh(), (double)tempZzr, (int)0, (SysParaInfo)modeDetailsVo.getSysparainfo());
        }
        double newAmount = cacheModel.getOrder().getOughtPay();
        inputAllVO.getResqVO().setCacheModel(cacheModel);
        return new RespBase(Code.SUCCESS, (Object)inputAllVO.getResqVO());
    }

    public RespBase<ResqVo> discAmount(ServiceSession session, InputAllVO inputAllVO) {
        Double discountAmount = inputAllVO.getDiscountAmount();
        if (discountAmount == null) {
            return Code.CODE_30040.getRespBase(new Object[]{"\u6298\u8ba9\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String accreditNo = inputAllVO.getAccreditNo();
        int mode = 0;
        if (!StringUtils.isBlank((String)inputAllVO.getMode())) {
            mode = CastUtil.castInt((Object)inputAllVO.getMode());
        }
        CacheModel cacheModel = inputAllVO.getResqVO().getCacheModel();
        session.setEnt_id(cacheModel.getOrder().getEntId());
        if (cacheModel == null) {
            return Code.CODE_30040.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355"});
        }
        if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
            return Code.CODE_30040.getRespBase(new Object[]{"\u8ba2\u5355\u4e3a\u5370\u82b1\u6362\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c"});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return Code.CODE_30040.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1"});
        }
        if (-1 == cacheModel.getCalcResult()) {
            return Code.CODE_30040.getRespBase(new Object[]{"CalcResult-1\u65f6\u4e0d\u80fd\u4fee\u6539\u5546\u54c1"});
        }
        if (null == accreditNo || "".equals(accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (cacheModel.getCurGrant().getPrivzpzkl() < 0.0) {
            return Code.CODE_30040.getRespBase(new Object[]{"\u5f53\u524d\u6388\u6743\u4eba\u5458\u4e0d\u5141\u8bb8\u6574\u5355\u6253\u6298"});
        }
        ModeDetailsVo modeDetailsVo = ModeDetailsUtils.geteModeDetails((String)session.getMode(), (String)cacheModel.getOrder().getShopCode(), (String)cacheModel.getOrder().getTerminalNo());
        double oldAmount = cacheModel.getOrder().getOughtPay();
        if (-1 == (cacheModel = PosLogicServiceImpl.CalcOrderRebateByAmountBeforeOrder((CacheModel)cacheModel, (String)accreditNo, (double)discountAmount, (int)mode, (SysParaInfo)modeDetailsVo.getSysparainfo())).getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)inputAllVO.getResqVO());
        }
        if (cacheModel == null || cacheModel.getGoodsList() == null || cacheModel.getOrder() == null) {
            return Code.CODE_30040.getRespBase(new Object[]{"\u6574\u5355\u6298\u8ba9\u8c03\u7528\u8ba1\u7b97\u65b9\u6cd5,\u6ca1\u6709\u83b7\u5f97\u6709\u6548CacheModel"});
        }
        inputAllVO.getResqVO().setCacheModel(cacheModel);
        if (-1 == cacheModel.getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)inputAllVO.getResqVO());
        }
        double newAmount = cacheModel.getOrder().getOughtPay();
        return new RespBase(Code.SUCCESS, (Object)inputAllVO.getResqVO());
    }

    public RespBase<ResqVo> singleDisc(ServiceSession session, InputSingleVO inputSingleVO) {
        Double discountRate = inputSingleVO.getDiscountRate();
        if (inputSingleVO.getMode().equals("1")) {
            discountRate = ManipulatePrecision.doubleConvert((double)(100.0 - discountRate));
        } else if (inputSingleVO.getMode().equals("0")) {
            // empty if block
        }
        if (discountRate == null) {
            return Code.CODE_30010.getRespBase(new Object[]{"\u6298\u6263\u7387\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String accreditNo = inputSingleVO.getAccreditNo();
        String guid = inputSingleVO.getGuid();
        if (guid == null || guid.isEmpty()) {
            return Code.CODE_30010.getRespBase(new Object[]{"\u5546\u54c1\u884c\u552f\u4e00\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        CacheModel cacheModel = inputSingleVO.getResqVO().getCacheModel();
        ModeDetailsVo modeDetailsVo = ModeDetailsUtils.geteModeDetails((String)session.getMode(), (String)cacheModel.getOrder().getShopCode(), (String)cacheModel.getOrder().getTerminalNo());
        if (null == cacheModel) {
            return Code.CODE_30010.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355"});
        }
        Goods existGood = Goods.findGoods((String)guid, (List)cacheModel.getGoodsList());
        if (null == existGood) {
            return Code.CODE_30010.getRespBase(new Object[]{"\u5355\u884c\u6298\u6263\u5546\u54c1\u65e0\u6cd5\u627e\u5230"});
        }
        if ("9".equals(existGood.getFlag())) {
            return Code.CODE_20107.getRespBase(new Object[]{"\u5355\u884c\u6298\u6263\u5546\u54c1\u65e0\u6cd5\u627e\u5230"});
        }
        int flowId = existGood.getFlowId();
        double oldAmount = cacheModel.getOrder().getOughtPay();
        if (null == accreditNo || "".equals(accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (cacheModel.getCurGrant().getPrivdpzkl() < 0.0) {
            return new RespBase(Code.CODE_1000.getIndex(), "\u5f53\u524d\u6388\u6743\u4eba\u5458\u4e0d\u5141\u8bb8\u5355\u54c1\u6253\u6298", (Object)inputSingleVO.getResqVO());
        }
        if (-1 == (cacheModel = PosLogicServiceImpl.CalcGoodsRebateByRateBeforeSingle((CacheModel)cacheModel, (int)flowId, (String)accreditNo, (double)discountRate, (SysParaInfo)modeDetailsVo.getSysparainfo())).getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)inputSingleVO.getResqVO());
        }
        PosLogicServiceImpl.calcOrderAmount((CacheModel)cacheModel);
        inputSingleVO.getResqVO().setCacheModel(cacheModel);
        double newAmount = cacheModel.getOrder().getOughtPay();
        return new RespBase(Code.SUCCESS, (Object)inputSingleVO.getResqVO());
    }

    public RespBase<ResqVo> singleDiscAmount(ServiceSession session, InputSingleVO inputSingleVO) {
        Double discountAmount = inputSingleVO.getDiscountAmount();
        if (discountAmount == null) {
            return Code.CODE_30020.getRespBase(new Object[]{"\u6298\u8ba9\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String accreditNo = inputSingleVO.getAccreditNo();
        String guid = inputSingleVO.getGuid();
        if (guid == null || guid.isEmpty()) {
            return Code.CODE_30020.getRespBase(new Object[]{"\u5546\u54c1\u884c\u552f\u4e00\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        CacheModel cacheModel = inputSingleVO.getResqVO().getCacheModel();
        ModeDetailsVo modeDetailsVo = ModeDetailsUtils.geteModeDetails((String)session.getMode(), (String)cacheModel.getOrder().getShopCode(), (String)cacheModel.getOrder().getTerminalNo());
        if (null == cacheModel) {
            return Code.CODE_30020.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355"});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return Code.CODE_30020.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1"});
        }
        Goods existGood = Goods.findGoods((String)guid, (List)cacheModel.getGoodsList());
        if (null == existGood) {
            return Code.CODE_30020.getRespBase(new Object[]{"\u5355\u884c\u6298\u6263\u5546\u54c1\u65e0\u6cd5\u627e\u5230"});
        }
        if ("9".equals(existGood.getFlag())) {
            return Code.CODE_20107.getRespBase(new Object[]{"\u5355\u884c\u6298\u6263\u5546\u54c1\u65e0\u6cd5\u627e\u5230"});
        }
        int flowId = existGood.getFlowId();
        if (null == accreditNo || "".equals(accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (cacheModel.getCurGrant().getPrivdpzkl() < 0.0) {
            return new RespBase(Code.CODE_1000.getIndex(), "\u5f53\u524d\u6388\u6743\u4eba\u5458\u4e0d\u5141\u8bb8\u5355\u54c1\u6253\u6298", (Object)inputSingleVO.getResqVO());
        }
        double oldAmount = cacheModel.getOrder().getOughtPay();
        if (-1 == (cacheModel = PosLogicServiceImpl.CalcGoodsRebateByAmountBeforeSingle((CacheModel)cacheModel, (int)flowId, (String)accreditNo, (double)discountAmount, (int)Integer.parseInt(inputSingleVO.getMode()), (boolean)false, (SysParaInfo)modeDetailsVo.getSysparainfo())).getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)inputSingleVO.getResqVO());
        }
        double newAmount = cacheModel.getOrder().getOughtPay();
        return new RespBase(Code.SUCCESS, (Object)inputSingleVO.getResqVO());
    }
}

