/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.api;

import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.bean.MsgType;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.util.sign.CertDescriptor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BasePayConfigStorage
implements PayConfigStorage {
    private volatile Object attach;
    private volatile CertDescriptor certDescriptor;
    private volatile String keyPrivate;
    private volatile String keyPrivateCertPwd;
    private volatile String keyPublic;
    private volatile String notifyUrl;
    private volatile String returnUrl;
    private volatile String signType;
    private volatile String inputCharset;
    private volatile String payType;
    private volatile MsgType msgType;
    private volatile String accessToken;
    private volatile long expiresTime;
    private Lock accessTokenLock = new ReentrantLock();
    private boolean isTest = false;
    private boolean isCertSign = false;

    @Override
    public Object getAttach() {
        return this.attach;
    }

    public void setAttach(Object attach) {
        this.attach = attach;
    }

    @Override
    public CertDescriptor getCertDescriptor() {
        if (!this.isCertSign) {
            throw new PayErrorException(new PayException("certDescriptor fail", "isCertSign is false"));
        }
        if (null == this.certDescriptor) {
            this.certDescriptor = new CertDescriptor();
        }
        return this.certDescriptor;
    }

    @Override
    public String getKeyPrivate() {
        return this.keyPrivate;
    }

    public void setKeyPrivate(String keyPrivate) {
        this.keyPrivate = keyPrivate;
    }

    @Override
    public String getKeyPrivateCertPwd() {
        return this.keyPrivateCertPwd;
    }

    public void setKeyPrivateCertPwd(String keyPrivateCertPwd) {
        this.keyPrivateCertPwd = keyPrivateCertPwd;
    }

    @Override
    public String getKeyPublic() {
        return this.keyPublic;
    }

    public void setKeyPublic(String keyPublic) {
        this.keyPublic = keyPublic;
    }

    @Override
    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @Override
    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    @Override
    public String getInputCharset() {
        return this.inputCharset;
    }

    public void setInputCharset(String inputCharset) {
        this.inputCharset = inputCharset;
    }

    @Override
    public String getPayType() {
        return this.payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    @Override
    public MsgType getMsgType() {
        return this.msgType;
    }

    public void setMsgType(MsgType msgType) {
        this.msgType = msgType;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public Lock getAccessTokenLock() {
        return this.accessTokenLock;
    }

    @Override
    public long getExpiresTime() {
        return this.expiresTime;
    }

    @Override
    public boolean isAccessTokenExpired() {
        return System.currentTimeMillis() > this.expiresTime;
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.accessToken = accessToken;
        this.expiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 600) * 1000L;
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, long expiresTime) {
        this.accessToken = accessToken;
        this.expiresTime = expiresTime;
    }

    @Override
    public void expireAccessToken() {
        this.expiresTime = 0L;
    }

    @Override
    public String getToken() {
        return null;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setExpiresTime(long expiresTime) {
        this.expiresTime = expiresTime;
    }

    public void setAccessTokenLock(Lock accessTokenLock) {
        this.accessTokenLock = accessTokenLock;
    }

    @Override
    public boolean isTest() {
        return this.isTest;
    }

    public void setTest(boolean test) {
        this.isTest = test;
    }

    public boolean isCertSign() {
        return this.isCertSign;
    }

    public void setCertSign(boolean certSign) {
        this.isCertSign = certSign;
        if (certSign) {
            this.certDescriptor = new CertDescriptor();
        }
    }
}

