/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.http;

import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

public class UriVariables {
    public static String getUri(String uri, Object ... uriVariables) {
        if (null == uriVariables) {
            return uri;
        }
        for (Object variable : uriVariables) {
            if (null == variable) continue;
            uri = uri.replaceFirst("\\{\\w+\\}", variable.toString());
        }
        return uri;
    }

    public static String getUri(String uri, Map<String, Object> uriVariables) {
        if (null == uriVariables) {
            return uri;
        }
        for (String key : uriVariables.keySet()) {
            Object uriVariable = uriVariables.get(key);
            if (null == uriVariable) continue;
            uri = uri.replace("{" + key + "}", uriVariable.toString());
        }
        return uri;
    }

    public static String getMapToParameters(Map pe) {
        StringBuilder builder = new StringBuilder();
        for (Object key : pe.keySet()) {
            Object o = pe.get(key);
            if (null == o) continue;
            if (o instanceof List) {
                o = ((List)o).toArray();
            }
            try {
                if (o instanceof Object[]) {
                    Object[] os = (Object[])o;
                    String valueStr = "";
                    int len = os.length;
                    for (int i = 0; i < len; ++i) {
                        if (null == os[i]) continue;
                        String value = os[i].toString().trim();
                        valueStr = valueStr + (i == len - 1 ? value : value + ",");
                    }
                    builder.append(key).append("=").append(URLEncoder.encode(valueStr, "utf-8")).append("&");
                    continue;
                }
                builder.append(key).append("=").append(URLEncoder.encode(pe.get(key).toString(), "utf-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static JSONObject getParametersToMap(String str) {
        JSONObject map = new JSONObject();
        int len = str.length();
        StringBuilder temp = new StringBuilder();
        String key = null;
        boolean isKey = true;
        boolean isOpen = false;
        char openName = '\u0000';
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                char curChar = str.charAt(i);
                if (isKey) {
                    if (curChar == '=') {
                        key = temp.toString();
                        temp.setLength(0);
                        isKey = false;
                        continue;
                    }
                    temp.append(curChar);
                    continue;
                }
                if (isOpen) {
                    if (curChar == openName) {
                        isOpen = false;
                    }
                } else {
                    if (curChar == '{') {
                        isOpen = true;
                        openName = '}';
                    }
                    if (curChar == '[') {
                        isOpen = true;
                        openName = ']';
                    }
                }
                if (curChar == '&' && !isOpen) {
                    UriVariables.putKeyValueToMap(temp, isKey, key, (Map<String, Object>)map);
                    temp.setLength(0);
                    isKey = true;
                    continue;
                }
                temp.append(curChar);
            }
            UriVariables.putKeyValueToMap(temp, isKey, key, (Map<String, Object>)map);
        }
        return map;
    }

    private static void putKeyValueToMap(StringBuilder temp, boolean isKey, String key, Map<String, Object> map) {
        if (isKey) {
            key = temp.toString();
            if (key.length() == 0) {
                throw new PayErrorException(new PayException("QString format illegal", "\u5185\u5bb9\u683c\u5f0f\u6709\u8bef"));
            }
            map.put(key, "");
        } else {
            if (key.length() == 0) {
                throw new PayErrorException(new PayException("QString format illegal", "\u5185\u5bb9\u683c\u5f0f\u6709\u8bef"));
            }
            map.put(key, temp.toString());
        }
    }
}

