/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.util.sign.encrypt;

import com.egzosn.pay.common.util.sign.encrypt.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSA {
    private static final String ALGORITHM = "RSA";
    private static final String SIGN_ALGORITHMS = "SHA1WithRSA";

    public static String sign(String content, String privateKey, String signAlgorithms, String characterEncoding) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decode(privateKey));
            KeyFactory keyf = KeyFactory.getInstance(ALGORITHM);
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance(signAlgorithms);
            signature.initSign(priKey);
            signature.update(content.getBytes(characterEncoding));
            byte[] signed = signature.sign();
            return Base64.encode(signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sign(String content, PrivateKey privateKey, String signAlgorithms, String characterEncoding) {
        try {
            Signature signature = Signature.getInstance(signAlgorithms);
            signature.initSign(privateKey);
            signature.update(content.getBytes(characterEncoding));
            byte[] signed = signature.sign();
            return Base64.encode(signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sign(String content, String privateKey, String characterEncoding) {
        return RSA.sign(content, privateKey, SIGN_ALGORITHMS, characterEncoding);
    }

    public static String sign(String content, PrivateKey privateKey, String characterEncoding) {
        return RSA.sign(content, privateKey, SIGN_ALGORITHMS, characterEncoding);
    }

    public static boolean verify(String content, String sign, String publicKey, String signAlgorithms, String characterEncoding) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            byte[] encodedKey = Base64.decode(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(signAlgorithms);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(characterEncoding));
            return signature.verify(Base64.decode(sign));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean verify(String content, String sign, PublicKey publicKey, String signAlgorithms, String characterEncoding) {
        try {
            Signature signature = Signature.getInstance(signAlgorithms);
            signature.initVerify(publicKey);
            signature.update(content.getBytes(characterEncoding));
            return signature.verify(Base64.decode(sign));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean verify(String content, String sign, String publicKey, String characterEncoding) {
        return RSA.verify(content, sign, publicKey, SIGN_ALGORITHMS, characterEncoding);
    }

    public static boolean verify(String content, String sign, PublicKey publicKey, String characterEncoding) {
        return RSA.verify(content, sign, publicKey, SIGN_ALGORITHMS, characterEncoding);
    }

    public static String decrypt(String content, String privateKey, String characterEncoding) throws Exception {
        int bufl;
        PrivateKey prikey = RSA.getPrivateKey(privateKey);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, prikey);
        ByteArrayInputStream ins = new ByteArrayInputStream(Base64.decode(content));
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        byte[] buf = new byte[128];
        while ((bufl = ins.read(buf)) != -1) {
            byte[] block = null;
            if (buf.length == bufl) {
                block = buf;
            } else {
                block = new byte[bufl];
                for (int i = 0; i < bufl; ++i) {
                    block[i] = buf[i];
                }
            }
            writer.write(cipher.doFinal(block));
        }
        return new String(writer.toByteArray(), characterEncoding);
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = Base64.decode(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }
}

