/*
 * Decompiled with CFR 0.152.
 */
package me.eleme.anubis.openapi.api.base;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import me.eleme.anubis.openapi.api.annotation.Service;
import me.eleme.anubis.openapi.api.exception.ServiceException;
import me.eleme.anubis.openapi.config.Config;
import me.eleme.anubis.openapi.config.oauth.response.Token;
import me.eleme.anubis.openapi.utils.WebUtils;

public class BaseBizApiService {
    private Token token;
    private Map<String, Method> methodMap = new HashMap<String, Method>();
    private Class service;
    private Config config;

    public BaseBizApiService(Config config, Token token, Class service) {
        Method[] methods;
        this.token = token;
        this.service = service;
        this.config = config;
        for (Method method : methods = service.getMethods()) {
            this.methodMap.put(method.getName(), method);
        }
    }

    public <T> T call(String action, Map<String, Object> parameters) throws ServiceException {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        Method method = this.getMethod(methodName);
        Service annotation = this.service.getAnnotation(Service.class);
        if (annotation == null) {
            throw new RuntimeException("\u670d\u52a1\u672a\u627e\u5230Service\u6ce8\u89e3");
        }
        return WebUtils.call(this.config, action, parameters, this.token, method.getGenericReturnType());
    }

    private Method getMethod(String methodName) {
        return this.methodMap.get(methodName);
    }
}

