/*
 * Decompiled with CFR 0.152.
 */
package me.eleme.anubis.openapi.config;

import me.eleme.anubis.openapi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private String appId;
    private String secretKey;
    private String serverUrl;
    private String oauthApiUrl;
    private String postUrl;
    private String bizApiUrl;

    public Config(boolean isSandbox, String appKey, String appSecret) {
        if (!StringUtils.areNotEmpty(appKey, appSecret)) {
            log.error("appKey and appSecret is required.");
        }
        this.appId = appKey;
        this.secretKey = appSecret;
        if (isSandbox) {
            this.serverUrl = "https://exam-anubis.ele.me/";
            this.oauthApiUrl = "https://exam-anubis.ele.me/anubis-webapi/openapi/";
            this.bizApiUrl = "https://exam-anubis.ele.me/anubis-webapi/v3/invoke/";
        } else {
            this.serverUrl = "https://open-anubis.ele.me/";
            this.oauthApiUrl = "https://open-anubis.ele.me/anubis-webapi/openapi/";
            this.bizApiUrl = "https://open-anubis.ele.me/anubis-webapi/v3/invoke/";
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getOauthApiUrl() {
        return this.oauthApiUrl;
    }

    public void setOauthApiUrl(String oauthApiUrl) {
        this.oauthApiUrl = oauthApiUrl;
    }

    public String getPostUrl() {
        return this.postUrl;
    }

    public void setPostUrl(String postUrl) {
        this.postUrl = postUrl;
    }

    public String getBizApiUrl() {
        return this.bizApiUrl;
    }

    public void setBizApiUrl(String bizApiUrl) {
        this.bizApiUrl = bizApiUrl;
    }
}

