/*
 * Decompiled with CFR 0.152.
 */
package me.eleme.anubis.openapi.demo;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import me.eleme.anubis.openapi.api.entity.order.AddTipReq;
import me.eleme.anubis.openapi.api.entity.order.AddTipRes;
import me.eleme.anubis.openapi.api.entity.order.CancelOrderReq;
import me.eleme.anubis.openapi.api.entity.order.CancelOrderRes;
import me.eleme.anubis.openapi.api.entity.order.CancelReasonListReq;
import me.eleme.anubis.openapi.api.entity.order.CancelReasonListRes;
import me.eleme.anubis.openapi.api.entity.order.ChainstoreRangeReq;
import me.eleme.anubis.openapi.api.entity.order.ChainstoreRangeRes;
import me.eleme.anubis.openapi.api.entity.order.ClaimOrderReq;
import me.eleme.anubis.openapi.api.entity.order.ClaimOrderRes;
import me.eleme.anubis.openapi.api.entity.order.ComplaintOrderReq;
import me.eleme.anubis.openapi.api.entity.order.ComplaintOrderRes;
import me.eleme.anubis.openapi.api.entity.order.CreateOrderReq;
import me.eleme.anubis.openapi.api.entity.order.CreateOrderRes;
import me.eleme.anubis.openapi.api.entity.order.GetAmountRes;
import me.eleme.anubis.openapi.api.entity.order.GetOrderDetailReq;
import me.eleme.anubis.openapi.api.entity.order.GetOrderDetailRes;
import me.eleme.anubis.openapi.api.entity.order.OrderItemOpenapiDTO;
import me.eleme.anubis.openapi.api.entity.order.PreCancelOrderReq;
import me.eleme.anubis.openapi.api.entity.order.PreCancelOrderRes;
import me.eleme.anubis.openapi.api.entity.order.PreCreateOrderReq;
import me.eleme.anubis.openapi.api.entity.order.PreCreateOrderRes;
import me.eleme.anubis.openapi.api.entity.shop.ChainstoreCreateReq;
import me.eleme.anubis.openapi.api.entity.shop.ChainstoreCreateRes;
import me.eleme.anubis.openapi.api.entity.shop.ChainstoreQueryListReq;
import me.eleme.anubis.openapi.api.entity.shop.ChainstoreQueryListRes;
import me.eleme.anubis.openapi.api.entity.shop.ChainstoreUpdateReq;
import me.eleme.anubis.openapi.api.entity.shop.ChainstoreUpdateRes;
import me.eleme.anubis.openapi.api.entity.shop.QueryChainStoreReq;
import me.eleme.anubis.openapi.api.entity.shop.ShopInfo;
import me.eleme.anubis.openapi.api.entity.shop.UploadImgReq;
import me.eleme.anubis.openapi.api.entity.shop.UploadImgRes;
import me.eleme.anubis.openapi.api.exception.ServiceException;
import me.eleme.anubis.openapi.api.service.OrderService;
import me.eleme.anubis.openapi.api.service.ShopService;
import me.eleme.anubis.openapi.config.Config;
import me.eleme.anubis.openapi.config.oauth.response.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientDemo {
    private static final Logger log = LoggerFactory.getLogger(HttpClientDemo.class);
    private static final boolean IS_SANDBOX = true;
    private static final String APP_ID = "app id";
    private static final String MERCHANT_ID = "merchant id";
    private static final String SECRET_KEY = "secret key";
    private static final Config CONFIG = new Config(true, "app id", "secret key");
    private static final Token TOKEN = new Token();

    public static void main(String[] args) {
        HttpClientDemo demo = new HttpClientDemo();
        demo.addTipTest();
    }

    private void uploadImgTest() {
        ShopService shopService = new ShopService(CONFIG, TOKEN);
        UploadImgReq uploadImgReq = new UploadImgReq();
        uploadImgReq.setFileType("jpg");
        String base64Str = "";
        uploadImgReq.setFileBinary(base64Str);
        try {
            UploadImgRes uploadImgRes = shopService.uploadImg(uploadImgReq);
            log.info("uploadImgRes:{}", (Object)JSON.toJSONString((Object)uploadImgRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void chainstoreQueryTest() {
        ShopService shopService = new ShopService(CONFIG, TOKEN);
        QueryChainStoreReq queryChainStoreReq = new QueryChainStoreReq();
        queryChainStoreReq.setMerchantId(MERCHANT_ID);
        queryChainStoreReq.setChainStoreId("100000");
        try {
            ShopInfo shop = shopService.getShop(queryChainStoreReq);
            log.info("shop:{}", (Object)JSON.toJSONString((Object)shop));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void chainstoreQueryListTest() {
        ShopService shopService = new ShopService(CONFIG, TOKEN);
        ChainstoreQueryListReq chainstoreQueryListReq = new ChainstoreQueryListReq();
        chainstoreQueryListReq.setMerchantId(MERCHANT_ID);
        chainstoreQueryListReq.setPageNo("1");
        chainstoreQueryListReq.setPageSize("10");
        try {
            ChainstoreQueryListRes chainstoreQueryList = shopService.chainstoreQueryList(chainstoreQueryListReq);
            log.info("chainstoreQueryList:{}", (Object)JSON.toJSONString((Object)chainstoreQueryList));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void chainstoreCreateTest() {
        ShopService shopService = new ShopService(CONFIG, TOKEN);
        ChainstoreCreateReq chainstoreCreateReq = new ChainstoreCreateReq();
        chainstoreCreateReq.setHeadShopName("\u95e8\u5e97\u6784\u5efa\u540d\u5b57");
        chainstoreCreateReq.setBranchShopName("\u5927\u671b\u8def\u5e97xx");
        chainstoreCreateReq.setChainStoreType(1);
        chainstoreCreateReq.setContactPhone("17700000000");
        chainstoreCreateReq.setAddress("\u5317\u4eac\u5e02\u671d\u9633\u533a\u897f\u5927\u671b\u8def1\u53f7");
        chainstoreCreateReq.setLongitude("118.1342");
        chainstoreCreateReq.setLatitude("40.235");
        chainstoreCreateReq.setPositionSource(3);
        chainstoreCreateReq.setOutShopCode("testKFC003444");
        chainstoreCreateReq.setCategoryId("12");
        chainstoreCreateReq.setOwnerName("\u5218xx");
        chainstoreCreateReq.setOwnerIdNum("410184198801011113");
        chainstoreCreateReq.setHandheldLicencePicHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreCreateReq.setOwnerIdPicBackHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreCreateReq.setOwnerIdPicFrontHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreCreateReq.setCreditCode("910X11103345");
        chainstoreCreateReq.setBusinessLicencePicHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreCreateReq.setFoodLicensePicHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreCreateReq.setSettlementModel("2");
        chainstoreCreateReq.setSettlementAccountId("102099");
        try {
            ChainstoreCreateRes chainstoreCreateRes = shopService.createChainstore(chainstoreCreateReq);
            log.info("chainstoreCreateRes:{}", (Object)JSON.toJSONString((Object)chainstoreCreateRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void chainstoreUpdateTest() {
        ShopService shopService = new ShopService(CONFIG, TOKEN);
        ChainstoreUpdateReq chainstoreUpdateReq = new ChainstoreUpdateReq();
        chainstoreUpdateReq.setChainStoreId("204409641");
        chainstoreUpdateReq.setHeadShopName("\u95e8\u5e97\u6784\u5efa\u540d\u5b57\u66f4\u6539");
        chainstoreUpdateReq.setBranchShopName("\u5927\u671b\u8defAAAA\u5e97");
        chainstoreUpdateReq.setLongitude("118.1342");
        chainstoreUpdateReq.setLatitude("40.235");
        chainstoreUpdateReq.setPositionSource(3);
        chainstoreUpdateReq.setOutShopCode("testKFC003444");
        chainstoreUpdateReq.setCategoryId("12");
        chainstoreUpdateReq.setOwnerName("\u5218xx");
        chainstoreUpdateReq.setOwnerIdNum("410184198801011113");
        chainstoreUpdateReq.setHandheldLicencePicHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreUpdateReq.setOwnerIdPicBackHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreUpdateReq.setOwnerIdPicFrontHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreUpdateReq.setCreditCode("910X11103345");
        chainstoreUpdateReq.setBusinessLicencePicHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreUpdateReq.setFoodLicensePicHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        try {
            ChainstoreUpdateRes chainstoreUpdateRes = shopService.updateChainstore(chainstoreUpdateReq);
            log.info("chainstoreUpdateRes:{}", (Object)JSON.toJSONString((Object)chainstoreUpdateRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void chainstoreRangeTest() {
        OrderService orderService = new OrderService(CONFIG, TOKEN);
        ChainstoreRangeReq chainstoreRangeReq = new ChainstoreRangeReq();
        chainstoreRangeReq.setChainStoreId(203040011);
        try {
            ChainstoreRangeRes chainstoreRangeRes = orderService.chainstoreRange(chainstoreRangeReq);
            log.info("chainstoreRangeRes:{}", (Object)JSON.toJSONString((Object)chainstoreRangeRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void preCreateOrderTest() {
        OrderService orderService = new OrderService(CONFIG, TOKEN);
        PreCreateOrderReq preCreateOrderReq = new PreCreateOrderReq();
        preCreateOrderReq.setChainStoreId(203040091L);
        preCreateOrderReq.setPartnerOrderCode("JSD4101231333235567");
        preCreateOrderReq.setBaseGoodsId(3000);
        preCreateOrderReq.setOrderSource(4);
        preCreateOrderReq.setOrderType(1);
        preCreateOrderReq.setPositionSource(3);
        preCreateOrderReq.setReceiverAddress("\u5317\u4eac\u5e02\u660c\u5e73\u533a\u4e2d\u4e1c\u8def0000");
        preCreateOrderReq.setReceiverLatitude(40.039115);
        preCreateOrderReq.setReceiverLongitude(116.39685489017384);
        preCreateOrderReq.setGoodsTotalAmountCent(1000L);
        preCreateOrderReq.setGoodsActualAmountCent(1000L);
        preCreateOrderReq.setRequireReceiveTime(System.currentTimeMillis() + 3600000L);
        preCreateOrderReq.setGoodsWeight(0.1);
        preCreateOrderReq.setGoodsCount(1);
        OrderItemOpenapiDTO orderItemOpenapiDTO = new OrderItemOpenapiDTO();
        orderItemOpenapiDTO.setItemName("KFC\u6c49\u5821\u4e00\u6253");
        orderItemOpenapiDTO.setItemQuantity(2);
        orderItemOpenapiDTO.setItemActualAmountCent(500L);
        orderItemOpenapiDTO.setItemAmountCent(500L);
        ArrayList<OrderItemOpenapiDTO> goodsItemList = new ArrayList<OrderItemOpenapiDTO>();
        goodsItemList.add(orderItemOpenapiDTO);
        preCreateOrderReq.setGoodsItemList(goodsItemList);
        log.info("preCreateOrderReq:{}", (Object)JSON.toJSONString((Object)preCreateOrderReq));
        try {
            PreCreateOrderRes preCreateOrderRes = orderService.preCreateOrder(preCreateOrderReq);
            log.info("preCreateOrderRes:{}", (Object)JSON.toJSONString((Object)preCreateOrderRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void getAmountTest() {
        OrderService orderService = new OrderService(CONFIG, TOKEN);
        try {
            GetAmountRes amount = orderService.getAmount();
            log.info("amount:{}", (Object)JSON.toJSONString((Object)amount));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void getOrderDetailTest() {
        OrderService orderService = new OrderService(CONFIG, TOKEN);
        try {
            GetOrderDetailReq orderDetailReq = new GetOrderDetailReq();
            orderDetailReq.setPartnerOrderCode("232232999uuF21");
            GetOrderDetailRes orderDetail = orderService.getOrderDetail(orderDetailReq);
            log.info("orderDetail:{}", (Object)JSON.toJSONString((Object)orderDetail));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void createOrderTest() {
        OrderService orderService = new OrderService(CONFIG, TOKEN);
        CreateOrderReq createOrderReq = new CreateOrderReq();
        createOrderReq.setChainStoreId("203040091");
        createOrderReq.setPartnerOrderCode("JSD4101231333235567");
        createOrderReq.setBaseGoodsId("3000");
        createOrderReq.setOrderSource("4");
        createOrderReq.setOrderType(1);
        createOrderReq.setPositionSource(3);
        createOrderReq.setReceiverAddress("\u5317\u4eac\u5e02\u660c\u5e73\u533a\u4e2d\u4e1c\u8def00000\u53f7");
        createOrderReq.setReceiverLatitude(40.039115);
        createOrderReq.setReceiverLongitude(116.307892);
        createOrderReq.setGoodsTotalAmountCent(1000L);
        createOrderReq.setGoodsActualAmountCent(1000L);
        createOrderReq.setRequireReceiveTime(System.currentTimeMillis() + 3600000L);
        createOrderReq.setGoodsWeight(0.1);
        createOrderReq.setGoodsCount(1);
        createOrderReq.setReceiverName("\u5f20\u4e09");
        createOrderReq.setReceiverPrimaryPhone("13123454567");
        OrderItemOpenapiDTO orderItemOpenapiDTO = new OrderItemOpenapiDTO();
        orderItemOpenapiDTO.setItemName("KFC\u6c49\u5821\u4e00\u6253");
        orderItemOpenapiDTO.setItemQuantity(2);
        orderItemOpenapiDTO.setItemActualAmountCent(500L);
        orderItemOpenapiDTO.setItemAmountCent(500L);
        ArrayList<OrderItemOpenapiDTO> goodsItemList = new ArrayList<OrderItemOpenapiDTO>();
        goodsItemList.add(orderItemOpenapiDTO);
        createOrderReq.setGoodsItemList(goodsItemList);
        log.info("createOrderReq:{}", (Object)JSON.toJSONString((Object)createOrderReq));
        try {
            CreateOrderRes order = orderService.createOrder(createOrderReq);
            log.info("order:{}", (Object)JSON.toJSONString((Object)order));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void preCancelOrderTest() {
        OrderService orderService = new OrderService(CONFIG, TOKEN);
        try {
            PreCancelOrderReq orderDetailReq = new PreCancelOrderReq();
            orderDetailReq.setPartnerOrderCode("232232999uuF21");
            PreCancelOrderRes preCancelOrderRes = orderService.preCancelOrder(orderDetailReq);
            log.info("preCancelOrderRes:{}", (Object)JSON.toJSONString((Object)preCancelOrderRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void cancelOrderTest() {
        OrderService orderService = new OrderService(CONFIG, TOKEN);
        try {
            CancelOrderReq orderDetailReq = new CancelOrderReq();
            orderDetailReq.setPartnerOrderCode("232232999uuF21");
            orderDetailReq.setOrderCancelRole(2);
            orderDetailReq.setOrderCancelCode(32);
            CancelOrderRes cancelOrderRes = orderService.cancelOrder(orderDetailReq);
            log.info("cancelOrderRes:{}", (Object)JSON.toJSONString((Object)cancelOrderRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void getCancelReasonListTest() {
        OrderService orderService = new OrderService(CONFIG, TOKEN);
        try {
            CancelReasonListReq orderDetailReq = new CancelReasonListReq();
            orderDetailReq.setOrderId("150000001061018385");
            CancelReasonListRes cancelReasonList = orderService.getCancelReasonList(orderDetailReq);
            log.info("cancelReasonList:{}", (Object)JSON.toJSONString((Object)cancelReasonList));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void complaintOrderTest() {
        OrderService orderService = new OrderService(CONFIG, TOKEN);
        try {
            ComplaintOrderReq complaintOrderReq = new ComplaintOrderReq();
            complaintOrderReq.setOrderId("150000001061018385");
            complaintOrderReq.setOrderComplaintCode(130);
            ComplaintOrderRes complaintOrderRes = orderService.complaintOrder(complaintOrderReq);
            log.info("complaintOrderRes:{}", (Object)JSON.toJSONString((Object)complaintOrderRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void claimOrderTest() {
        OrderService orderService = new OrderService(CONFIG, TOKEN);
        try {
            ClaimOrderReq claimOrderReq = new ClaimOrderReq();
            claimOrderReq.setOrderId("150000001061018385");
            claimOrderReq.setOrderClaimCode(150);
            claimOrderReq.setOrderClaimPriceCent(1000L);
            ClaimOrderRes claimOrderRes = orderService.claimOrder(claimOrderReq);
            log.info("claimOrderRes:{}", (Object)JSON.toJSONString((Object)claimOrderRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void addTipTest() {
        OrderService orderService = new OrderService(CONFIG, TOKEN);
        try {
            AddTipReq addTipReq = new AddTipReq();
            addTipReq.setOrderId("150000001104501521");
            addTipReq.setAddTipAmountCent(500L);
            addTipReq.setThirdIndexId(1L);
            AddTipRes addTipRes = orderService.addTip(addTipReq);
            log.info("addTipRes:{}", (Object)JSON.toJSONString((Object)addTipRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    static {
        TOKEN.setAccessToken("");
        TOKEN.setAppId(APP_ID);
        TOKEN.setMerchantId(MERCHANT_ID);
    }
}

