/*
 * Decompiled with CFR 0.152.
 */
package me.eleme.anubis.openapi.demo;

import com.alibaba.fastjson.JSON;
import me.eleme.anubis.openapi.api.exception.ServiceException;
import me.eleme.anubis.openapi.config.Config;
import me.eleme.anubis.openapi.config.oauth.response.Token;
import me.eleme.anubis.openapi.oauth.OauthClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OauthClientDemo {
    private static final Logger log = LoggerFactory.getLogger(OauthClientDemo.class);
    private static final boolean IS_SANDBOX = false;
    private static final String APP_ID = "app id";
    private static final String SECRET_KEY = "secret key";
    private static final OauthClient CLIENT;
    private static final Config CONFIG;

    public static void main(String[] args) {
        OauthClientDemo demo = new OauthClientDemo();
        demo.serverTokenTest();
    }

    private void serverTokenTest() {
        String autoCode = "code";
        String redirectUri = "http://localhost:8899/demo";
        String merchantId = "87891";
        Token token = null;
        try {
            token = CLIENT.getTokenByCode(autoCode, merchantId, redirectUri);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        log.info("token:{}", (Object)JSON.toJSONString((Object)token));
    }

    private void getTokenByRefreshTokenTest() {
        String refreshToken = "";
        String merchantId = "";
        Token token = null;
        try {
            token = CLIENT.getTokenByRefreshToken(merchantId, refreshToken);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        log.info("token:{}", (Object)JSON.toJSONString((Object)token));
    }

    static {
        CONFIG = new Config(false, APP_ID, SECRET_KEY);
        CLIENT = new OauthClient(CONFIG);
    }
}

