/*
 * Decompiled with CFR 0.152.
 */
package me.eleme.anubis.openapi.oauth;

import java.lang.reflect.Type;
import me.eleme.anubis.openapi.api.exception.ServiceException;
import me.eleme.anubis.openapi.config.Config;
import me.eleme.anubis.openapi.config.oauth.response.Token;
import me.eleme.anubis.openapi.oauth.IoauthClient;
import me.eleme.anubis.openapi.oauth.impl.DefaultOauthClient;
import me.eleme.anubis.openapi.oauth.request.ServerRefreshTokenRequest;
import me.eleme.anubis.openapi.oauth.request.ServerTokenRequest;
import me.eleme.anubis.openapi.utils.SignatureUtil;

public class OauthClient {
    private Config config;
    private IoauthClient ioAuthClient = null;

    public OauthClient(Config config) {
        this.config = config;
    }

    public Token getTokenByCode(String authCode, String merchantId, String redirectUri) throws ServiceException {
        this.ioAuthClient = new DefaultOauthClient(this.config, "token");
        ServerTokenRequest serverTokenRequest = new ServerTokenRequest(this.config);
        serverTokenRequest.setCode(authCode);
        serverTokenRequest.setMerchantId(merchantId);
        serverTokenRequest.setRedirectUri(redirectUri);
        serverTokenRequest.setTimestamp("" + System.currentTimeMillis());
        String sortedParamsStr = SignatureUtil.sortGetTokenParams(this.config.getAppId(), merchantId, System.currentTimeMillis() + "", authCode);
        String signature = SignatureUtil.genSignature(this.config.getSecretKey(), sortedParamsStr);
        serverTokenRequest.setSignature(signature);
        Token token = (Token)this.ioAuthClient.execute(serverTokenRequest, (Type)((Object)Token.class));
        return token;
    }

    public Token getTokenByRefreshToken(String merchantId, String refreshToken) throws ServiceException {
        this.ioAuthClient = new DefaultOauthClient(this.config, "refreshToken");
        ServerRefreshTokenRequest refreshTokenRequest = new ServerRefreshTokenRequest(this.config);
        refreshTokenRequest.setRefreshToken(refreshToken);
        refreshTokenRequest.setMerchantId(merchantId);
        refreshTokenRequest.setTimestamp("" + System.currentTimeMillis());
        String sortedParamsStr = SignatureUtil.sortRefreshTokenParams(this.config.getAppId(), merchantId, System.currentTimeMillis() + "", refreshToken);
        String signature = SignatureUtil.genSignature(this.config.getSecretKey(), sortedParamsStr);
        refreshTokenRequest.setSignature(signature);
        Token token = (Token)this.ioAuthClient.execute(refreshTokenRequest, (Type)((Object)Token.class));
        return token;
    }
}

