/*
 * Decompiled with CFR 0.152.
 */
package me.eleme.anubis.openapi.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.eleme.anubis.openapi.utils.Sha256Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureUtil {
    private static final Logger log = LoggerFactory.getLogger(SignatureUtil.class);

    public static String genSignature(String secretKey, String toSignPara) {
        return Sha256Util.getsha256(secretKey + toSignPara);
    }

    public static String sortGetTokenParams(String appId, String merchantId, String timeStamp, String code) {
        HashMap<String, String> pMap = new HashMap<String, String>(8);
        pMap.put("grant_type", "authorization_code");
        pMap.put("app_id", appId);
        pMap.put("merchant_id", merchantId);
        pMap.put("timestamp", timeStamp);
        pMap.put("code", code);
        return SignatureUtil.sortParams(pMap);
    }

    public static String sortRefreshTokenParams(String appId, String merchantId, String timeStamp, String refreshToken) {
        HashMap<String, String> pMap = new HashMap<String, String>(8);
        pMap.put("grant_type", "refresh_token");
        pMap.put("app_id", appId);
        pMap.put("merchant_id", merchantId);
        pMap.put("timestamp", timeStamp);
        pMap.put("refresh_token", refreshToken);
        return SignatureUtil.sortParams(pMap);
    }

    public static String sortApiParams(String appId, String merchantId, String timeStamp, String accessToken, String businessData) {
        HashMap<String, String> pMap = new HashMap<String, String>(8);
        pMap.put("app_id", appId);
        pMap.put("merchant_id", merchantId);
        pMap.put("timestamp", timeStamp);
        pMap.put("version", "1.0");
        pMap.put("access_token", accessToken);
        pMap.put("business_data", businessData);
        return SignatureUtil.sortParams(pMap);
    }

    public static String sortParams(Map<String, String> paramMap) {
        ArrayList<String> keys = new ArrayList<String>(paramMap.keySet());
        Collections.sort(keys);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = paramMap.get(key);
            if (value == null || value.length() == 0) continue;
            content.append(i == 0 ? "" : "&").append(key).append("=").append(value);
        }
        return content.toString();
    }
}

