/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.builder.impl;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeWriterImpl
extends CodeWriter {
    private final File baseDir;
    private final boolean overwrite;
    private final Map<String, File> sources = new HashMap<String, File>();

    public CodeWriterImpl() throws IOException {
        this(null);
    }

    public CodeWriterImpl(String outputDir) throws IOException {
        this.overwrite = true;
        if (outputDir == null) {
            outputDir = System.getProperty("com.envoisolutions.sxc.output.directory");
        }
        if (outputDir == null) {
            this.baseDir = File.createTempFile("compile", "");
            this.baseDir.delete();
        } else {
            this.baseDir = new File(outputDir);
        }
        this.baseDir.mkdirs();
    }

    public CodeWriterImpl(File baseDir, boolean overwrite) {
        this.baseDir = baseDir;
        this.overwrite = overwrite;
    }

    public Map<String, File> getSources() {
        return this.sources;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public OutputStream openBinary(JPackage jpackage, String fileName) throws IOException {
        File file = jpackage.isUnnamed() ? new File(this.baseDir, fileName) : new File(new File(this.baseDir, jpackage.name().replace('.', File.separatorChar)), fileName);
        file.getParentFile().mkdirs();
        if (file.exists()) {
            if (!this.overwrite) {
                return new OutputStream(){

                    public void write(int ignored) throws IOException {
                    }
                };
            }
            file.delete();
            if (file.exists()) {
                throw new IOException("Unable to overwrite " + file.getName());
            }
        }
        String className = jpackage.name() + "." + fileName.replace(".java", "");
        this.sources.put(className, file);
        return new FileOutputStream(file);
    }

    public void close() throws IOException {
    }
}

