/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.builder.impl;

import com.envoisolutions.sxc.builder.BuildException;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIfElseBlock
implements JStatement {
    private final List<IfCondition> ifConditions = new ArrayList<IfCondition>();
    private JBlock elseBlock;
    private Exception declaredLocation = new Exception("Declared location");

    public JBlock addCondition(JExpression condition) {
        IfCondition ifCondition = new IfCondition(condition);
        this.ifConditions.add(ifCondition);
        return ifCondition.block;
    }

    public List<IfCondition> ifConditions() {
        return this.ifConditions;
    }

    public JBlock _else() {
        if (this.elseBlock == null) {
            this.elseBlock = new JBlock();
        }
        return this.elseBlock;
    }

    public void state(JFormatter f) {
        if (this.ifConditions.isEmpty()) {
            if (this.elseBlock != null) {
                throw new BuildException("If else block has an else block but no if blocks", this.declaredLocation);
            }
            return;
        }
        Iterator<IfCondition> iterator = this.ifConditions.iterator();
        while (iterator.hasNext()) {
            IfCondition ifCondition = iterator.next();
            if (this.alreadyHasParentheses(ifCondition.test)) {
                f.p("if ").g((JGenerable)ifCondition.test);
            } else {
                f.p("if (").g((JGenerable)ifCondition.test).p(")");
            }
            f.g((JGenerable)ifCondition.block);
            if (!iterator.hasNext()) continue;
            f.p("else ");
        }
        if (this.elseBlock != null) {
            f.p("else ").g((JGenerable)this.elseBlock);
        }
        f.nl();
    }

    private boolean alreadyHasParentheses(JExpression condition) {
        String conditionType = condition.getClass().getName();
        return "com.sun.codemodel.JOp$UnaryOp".equals(conditionType) || "com.sun.codemodel.JOp$BinaryOp".equals(conditionType);
    }

    public static class IfCondition {
        private final JExpression test;
        private final JBlock block = new JBlock();

        private IfCondition(JExpression test) {
            this.test = test;
        }

        public JExpression test() {
            return this.test;
        }

        public JBlock body() {
            return this.block;
        }
    }
}

