/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.compiler;

import com.envoisolutions.sxc.compiler.JavacCompiler;
import java.io.File;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Compiler {
    public static String JAVAC = "javac";
    public static String ECLIPSE = "eclipse";

    public static Compiler newInstance() {
        return Compiler.newInstance(null);
    }

    public static Compiler newInstance(String compiler) {
        if (JAVAC.equalsIgnoreCase(compiler)) {
            return new JavacCompiler();
        }
        if (ECLIPSE.equalsIgnoreCase(compiler)) {
            return Compiler.createEclipseCompiler();
        }
        if (compiler != null) {
            throw new IllegalArgumentException("Unknown compiler " + compiler);
        }
        try {
            Compiler.class.getClassLoader().loadClass("org.eclipse.jdt.internal.compiler.Compiler");
            return Compiler.createEclipseCompiler();
        }
        catch (ClassNotFoundException e) {
            return new JavacCompiler();
        }
    }

    private static Compiler createEclipseCompiler() {
        try {
            ClassLoader loader = Compiler.class.getClassLoader();
            Class<?> ecliplseCompiler = loader.loadClass("com.envoisolutions.sxc.compiler.EclipseCompiler");
            return (Compiler)ecliplseCompiler.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create eclipse compiler");
        }
    }

    public abstract ClassLoader compile(Map<String, File> var1);
}

