/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.GeometryException;
import org.json.JSONObject;

final class JSONObjectEnumerator {
    private JSONObject m_jsonObject;
    private boolean m_bStarted = false;
    private int m_currentIndex = -1;
    private String[] m_keys;

    JSONObjectEnumerator(JSONObject jsonObject) {
        this.m_jsonObject = jsonObject;
    }

    String getCurrentKey() {
        if (!this.m_bStarted) {
            throw new GeometryException("invalid call");
        }
        if (this.m_currentIndex == this.m_jsonObject.length()) {
            throw new GeometryException("invalid call");
        }
        return this.m_keys[this.m_currentIndex];
    }

    Object getCurrentObject() {
        if (!this.m_bStarted) {
            throw new GeometryException("invalid call");
        }
        if (this.m_currentIndex == this.m_jsonObject.length()) {
            throw new GeometryException("invalid call");
        }
        return this.m_jsonObject.opt(this.m_keys[this.m_currentIndex]);
    }

    boolean next() {
        if (!this.m_bStarted) {
            this.m_currentIndex = 0;
            this.m_keys = JSONObject.getNames((JSONObject)this.m_jsonObject);
            this.m_bStarted = true;
        } else if (this.m_currentIndex != this.m_jsonObject.length()) {
            ++this.m_currentIndex;
        }
        return this.m_currentIndex != this.m_jsonObject.length();
    }
}

