/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.orm.mapper.dialectsql;

import com.f2bpm.base.core.app.AppConfig;
import com.f2bpm.base.core.utils.AppUtil;
import com.f2bpm.orm.mapper.dialectsql.IDialectSql;
import com.f2bpm.orm.mapper.dialectsql.MySQLDialectSql;
import com.f2bpm.orm.mapper.dialectsql.OracleDialectSql;
import com.f2bpm.orm.mapper.dialectsql.PostgreSQLDialectSql;
import com.f2bpm.orm.mapper.dialectsql.SQLServerDialectSql;

public class FactoryDialect {
    public static IDialectSql getDialect() {
        String dbType = AppConfig.getDbType();
        return FactoryDialect.getDialect(dbType);
    }

    public static IDialectSql getDialect(String dalType) {
        switch (dalType) {
            case "oracle": {
                return (IDialectSql)AppUtil.getBean(OracleDialectSql.class);
            }
            case "mysql": {
                return (IDialectSql)AppUtil.getBean(MySQLDialectSql.class);
            }
            case "postgresql": {
                return (IDialectSql)AppUtil.getBean(PostgreSQLDialectSql.class);
            }
            case "sqlserver": {
                return (IDialectSql)AppUtil.getBean(SQLServerDialectSql.class);
            }
            case "mssql": {
                return (IDialectSql)AppUtil.getBean(SQLServerDialectSql.class);
            }
        }
        return null;
    }
}

