/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.orm.mapper.dialectsql;

import com.f2bpm.orm.mapper.dialectsql.DialectSql;
import org.springframework.stereotype.Service;

@Service(value="oracleDialectSql")
public class OracleDialectSql
extends DialectSql {
    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsLimitOffset() {
        return true;
    }

    @Override
    public String getTopExpression(int topN) {
        return " rownum<= " + topN;
    }

    @Override
    public String getTopSql(String sql, int topN) {
        if (sql.toLowerCase().contains("rownum")) {
            return sql;
        }
        if (sql.toLowerCase().contains("where")) {
            if (sql.toLowerCase().contains(" order ") && sql.toLowerCase().contains(" by ")) {
                int index = sql.lastIndexOf(" order ");
                StringBuilder sb = new StringBuilder(sql);
                sb.insert(index, "  and rownum<=" + topN + "  ");
                sql = sb.toString();
                return sql;
            }
            return sql + "  and rownum<=" + topN + " ";
        }
        return sql + "  where rownum<=" + topN + " ";
    }

    @Override
    public String getLimitString(String sql, int offset, String offsetPlaceholder, int limit, String limitPlaceholder) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (sql.toLowerCase().endsWith(" for update")) {
            sql = sql.substring(0, sql.length() - 11);
            isForUpdate = true;
        }
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100);
        if (offset > 0) {
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (offset > 0) {
            String endString = offsetPlaceholder + "+" + limitPlaceholder;
            pagingSelect.append(" ) row_ ) where rownum_ <= " + endString + " and rownum_ > " + offsetPlaceholder);
        } else {
            pagingSelect.append(" ) where rownum <= " + limitPlaceholder);
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        return pagingSelect.toString();
    }
}

