/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.org.mybatis.spring;

import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.f2bpm.base.core.app.AppConfig;
import com.f2bpm.base.core.app.AppProperties;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.orm.datasource.DataSourceUtil;
import com.zaxxer.hikari.HikariConfig;
import java.util.ArrayList;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
public class F2bpmSqlSessionTemplateBuild {
    public static SqlSessionTemplate f2bpmSqlSessionTemplate;
    public static SqlSessionTemplate f2bpmOrgImplSqlSessionTemplate;
    @Autowired
    DataSource dataSource;
    DataSource orgImplDatasource;
    @Autowired
    AppProperties appProperties;

    @Primary
    @Bean(name={"f2bpmSqlSessionTemplate"})
    public SqlSessionTemplate getF2bpmSqlSessionTemplateImpl() throws Exception {
        SqlSessionTemplate sessionTemplate;
        String[] arrPath;
        if (AppConfig.appProperties == null) {
            AppConfig.setAppPropertiesBean((AppProperties)this.appProperties);
        }
        if (StringUtil.isEmpty((String)((String)this.appProperties.getDb().get("daltype")))) {
            System.err.println("==========>>>>> error:yml\u914d\u7f6e\u8bfb\u53d6\u5931\u8d25================");
            SqlSessionFactoryBean sqlSessionFactory_temp = new SqlSessionFactoryBean();
            sqlSessionFactory_temp.setDataSource(this.dataSource);
            SqlSessionFactory factory_temp = sqlSessionFactory_temp.getObject();
            return new SqlSessionTemplate(factory_temp);
        }
        MybatisSqlSessionFactoryBean sqlSessionFactory = new MybatisSqlSessionFactoryBean();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        sqlSessionFactory.setConfigLocation(resolver.getResource((String)this.appProperties.getMybatis().get("config-location")));
        ArrayList<Resource> listmappeResources = new ArrayList<Resource>();
        String mapperLocationPath = (String)this.appProperties.getMybatis().get("mapper-locations");
        for (String path : arrPath = mapperLocationPath.split(",")) {
            Resource[] resourcesMaps = resolver.getResources(path);
            if (resourcesMaps == null || resourcesMaps.length <= 0) continue;
            listmappeResources.addAll(Arrays.asList(resourcesMaps));
        }
        Resource[] array = new Resource[listmappeResources.size()];
        Resource[] mapperLocations = listmappeResources.toArray(array);
        sqlSessionFactory.setDataSource(this.dataSource);
        sqlSessionFactory.setMapperLocations(mapperLocations);
        SqlSessionFactory factory = sqlSessionFactory.getObject();
        f2bpmSqlSessionTemplate = sessionTemplate = new SqlSessionTemplate(factory);
        System.out.println(StringUtil.startLine + "F2BPM Mybatis\u914d\u7f6e\u6210\u529f");
        System.out.println(StringUtil.line);
        return f2bpmSqlSessionTemplate;
    }

    @Bean(name={"orgimpl_f2bpmSqlSessionTemplate"})
    public SqlSessionTemplate getF2bpmOrgImplSqlSessionTemplateImpl() throws Exception {
        SqlSessionTemplate sessionTemplate;
        String[] arrPath;
        if (!Boolean.valueOf((String)this.appProperties.getOrgimpl().get("dbseparation")).booleanValue() || StringUtil.isEmpty((String)((String)this.appProperties.getDb().get("daltype")))) {
            return f2bpmSqlSessionTemplate;
        }
        String pooltype = (String)AppConfig.appProperties.getDb().get("type");
        System.out.println(StringUtil.startLine + "Orgimpl Pool Type " + pooltype);
        this.orgImplDatasource = pooltype.equalsIgnoreCase("com.zaxxer.hikari.HikariDataSource") ? this.getOrgImplHikariCPDatasource() : this.getOrgImplDruidDatasource();
        MybatisSqlSessionFactoryBean sqlSessionFactory = new MybatisSqlSessionFactoryBean();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        sqlSessionFactory.setConfigLocation(resolver.getResource((String)this.appProperties.getMybatis().get("config-location")));
        ArrayList<Resource> listmappeResources = new ArrayList<Resource>();
        String mapperLocationPath = (String)this.appProperties.getMybatis().get("mapper-locations");
        for (String path : arrPath = mapperLocationPath.split(",")) {
            Resource[] resourcesMaps = resolver.getResources(path);
            if (resourcesMaps == null || resourcesMaps.length <= 0) continue;
            listmappeResources.addAll(Arrays.asList(resourcesMaps));
        }
        Resource[] array = new Resource[listmappeResources.size()];
        Resource[] mapperLocations = listmappeResources.toArray(array);
        sqlSessionFactory.setDataSource(this.orgImplDatasource);
        sqlSessionFactory.setMapperLocations(mapperLocations);
        SqlSessionFactory factory = sqlSessionFactory.getObject();
        f2bpmOrgImplSqlSessionTemplate = sessionTemplate = new SqlSessionTemplate(factory);
        System.out.println(StringUtil.startLine + "\u63a5\u5165\u7ec4\u7ec7\u67b6\u6784Mybatis\u914d\u7f6e\u6210\u529f");
        System.out.println(StringUtil.line);
        return f2bpmOrgImplSqlSessionTemplate;
    }

    public DataSource getOrgImplHikariCPDatasource() throws Exception {
        String url = AppConfig.getApp((String)"orgimpl_url");
        String orgimpl_driverClassName = AppConfig.getApp((String)"orgimpl_driverClassName");
        String username = AppConfig.getApp((String)"orgimpl_username");
        String password = AppConfig.getApp((String)"orgimpl_password");
        int minimumidle = AppConfig.getIntApp((String)"minimum-idle");
        int idletimeout = AppConfig.getIntApp((String)"idle-timeout");
        int maximumpoolsize = AppConfig.getIntApp((String)"maximum-pool-size");
        int maxlifetime = AppConfig.getIntApp((String)"max-lifetime");
        int connectiontimeout = AppConfig.getIntApp((String)"connection-timeout");
        HikariConfig configuration = new HikariConfig();
        configuration.setJdbcUrl(url);
        configuration.setDriverClassName(orgimpl_driverClassName);
        configuration.setUsername(username);
        configuration.setPassword(password);
        configuration.setMinimumIdle(minimumidle);
        configuration.setIdleTimeout((long)idletimeout);
        configuration.setMaximumPoolSize(maximumpoolsize);
        configuration.setMaxLifetime((long)maxlifetime);
        configuration.setConnectionTimeout((long)connectiontimeout);
        configuration.addDataSourceProperty("pool-name", (Object)"OrgImplHikariCP");
        DataSource dSource = DataSourceUtil.getNewHikariDataSource(configuration);
        if (dSource != null) {
            System.out.println(StringUtil.startLine + "\u63a5\u5165\u7ec4\u7ec7\u67b6\u6784Hikari DataSource\u914d\u7f6e\u6210\u529f");
            System.out.println(StringUtil.line);
        } else {
            System.out.println(StringUtil.startLine + "error:\u63a5\u5165\u7ec4\u7ec7\u67b6\u6784Hikari DataSource\u914d\u7f6e\u5931\u8d25");
            System.out.println(StringUtil.line);
        }
        return dSource;
    }

    public DataSource getOrgImplDruidDatasource() throws Exception {
        String minEvictableIdleTimeMillis;
        String timeBetweenEvictionRunsMillis;
        String maxPoolPreparedStatementPerConnectionSize;
        boolean poolPreparedStatements;
        String validationQuery;
        boolean testOnReturn;
        boolean testOnBorrow;
        boolean testWhileIdle;
        String maxWait;
        String initialSize;
        String maxActive;
        String filters;
        String password;
        String url = AppConfig.getApp((String)"orgimpl_url");
        String driverClassName = "";
        String orgimpl_driverClassName = AppConfig.getApp((String)"orgimpl_driverClassName");
        driverClassName = StringUtil.isEmpty((String)orgimpl_driverClassName) ? AppConfig.getApp((String)"driverClassName") : orgimpl_driverClassName;
        String username = AppConfig.getApp((String)"orgimpl_username");
        DataSource dSource = DataSourceUtil.getNewDruidDataSource(url, username, password = AppConfig.getApp((String)"orgimpl_password"), driverClassName, filters = AppConfig.getApp((String)"filters"), maxActive = AppConfig.getApp((String)"maxActive"), initialSize = AppConfig.getApp((String)"initialSize"), maxWait = AppConfig.getApp((String)"maxWait"), testWhileIdle = AppConfig.getBoolApp((String)"testWhileIdle"), testOnBorrow = AppConfig.getBoolApp((String)"testOnBorrow"), testOnReturn = AppConfig.getBoolApp((String)"testOnReturn"), validationQuery = AppConfig.getApp((String)"validationQuery"), poolPreparedStatements = AppConfig.getBoolApp((String)"poolPreparedStatements"), maxPoolPreparedStatementPerConnectionSize = AppConfig.getApp((String)"maxPoolPreparedStatementPerConnectionSize"), timeBetweenEvictionRunsMillis = AppConfig.getApp((String)"timeBetweenEvictionRunsMillis"), minEvictableIdleTimeMillis = AppConfig.getApp((String)"minEvictableIdleTimeMillis"), 10, false);
        if (dSource != null) {
            System.out.println(StringUtil.startLine + "\u63a5\u5165\u7ec4\u7ec7\u67b6\u6784DataSource\u914d\u7f6e\u6210\u529f");
            System.out.println(StringUtil.line);
        } else {
            System.out.println(StringUtil.startLine + "error:\u63a5\u5165\u7ec4\u7ec7\u67b6\u6784DataSource\u914d\u7f6e\u5931\u8d25");
            System.out.println(StringUtil.line);
        }
        return dSource;
    }
}

