/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.org.mybatis.spring;

import com.f2bpm.orm.mapper.MappingUtil;
import javax.xml.bind.JAXBException;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ObjectUtils;

public class ZibortSqlSessionFactoryBean
extends SqlSessionFactoryBean {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Resource[] mappingAllLocation;

    protected SqlSessionFactory buildSqlSessionFactory() throws Exception {
        SqlSessionFactory sqlSessionFactory = super.buildSqlSessionFactory();
        Configuration configuration = sqlSessionFactory.getConfiguration();
        if (this.mappingAllLocation != null && this.mappingAllLocation.length > 0) {
            try {
                String[] mappingLocations = MappingUtil.getMappingLocations(this.mappingAllLocation[0].getFile());
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                for (int i = 0; i < mappingLocations.length; ++i) {
                    if (mappingLocations[i] == null) continue;
                    Resource[] mappingAllLocations = resolver.getResources(mappingLocations[i]);
                    this.loadMapping(configuration, mappingAllLocations);
                }
                SqlSessionFactoryBuilder sqlSessionFactoryBuilder = new SqlSessionFactoryBuilder();
                sqlSessionFactory = sqlSessionFactoryBuilder.build(configuration);
                this.logger.debug("load mapping for f2bpm-mapping-all.xml success  " + mappingLocations.length);
            }
            catch (JAXBException e) {
                this.logger.debug("load mapping for f2bpm-mapping-all.xml failure. msg=" + e.getMessage());
            }
        }
        return sqlSessionFactory;
    }

    public void setMappingAllLocation(Resource[] mappingAllLocation) {
        this.mappingAllLocation = mappingAllLocation;
    }

    private void loadMapping(Configuration configuration, Resource[] mappingAllLocations) throws NestedIOException {
        if (!ObjectUtils.isEmpty((Object[])mappingAllLocations)) {
            for (Resource mapperLocation : mappingAllLocations) {
                if (mapperLocation == null) continue;
                try {
                    XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(mapperLocation.getInputStream(), configuration, mapperLocation.toString(), configuration.getSqlFragments());
                    xmlMapperBuilder.parse();
                }
                catch (Exception e) {
                    throw new NestedIOException("Failed to parse mapping resource: '" + mapperLocation + "'", (Throwable)e);
                }
                finally {
                    ErrorContext.instance().reset();
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Parsed mapper file: '" + mapperLocation + "'");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Property 'mapperLocations' was not specified or no matching resources found");
        }
    }
}

