/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.orm.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.f2bpm.base.core.utils.AppUtil;
import com.f2bpm.orm.jdbcs.JdbcTemplateHelper;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class DataSourceUtil {
    public static final String localDataSource = "_localDataSource";
    private static Map<String, DataSource> dataSourcesMap = new HashMap<String, DataSource>();

    public static DataSource getLocalDataSource() throws IllegalAccessException, NoSuchFieldException {
        if (DataSourceUtil.isExistDataSource(localDataSource)) {
            DataSource dSource = DataSourceUtil.getDataSourceByKey(localDataSource);
            return dSource;
        }
        DataSource source = (DataSource)AppUtil.getBean((String)"dataSource");
        DataSourceUtil.addDataSource(localDataSource, source, true);
        return source;
    }

    public static void addDataSource(String key, DataSource dataSource, boolean replace) {
        if (dataSourcesMap.containsKey(key)) {
            if (!replace) {
                return;
            }
            dataSourcesMap.remove(key);
        }
        dataSourcesMap.put(key, dataSource);
    }

    public static void removeDataSource(String key) {
        if (dataSourcesMap.containsKey(key)) {
            dataSourcesMap.remove(key);
        }
    }

    public static boolean isExistDataSource(String key) {
        return dataSourcesMap.containsKey(key);
    }

    public static Map<String, DataSource> getAllDataSources() {
        return dataSourcesMap;
    }

    private static DataSource getDataSourceByKey(String key) throws IllegalAccessException, NoSuchFieldException {
        for (String dsKey : dataSourcesMap.keySet()) {
            if (!dsKey.equalsIgnoreCase(key)) continue;
            DataSource dSource = dataSourcesMap.get(dsKey);
            if (dSource == null) {
                dataSourcesMap.remove(key);
            }
            return dSource;
        }
        if (key.equalsIgnoreCase(localDataSource)) {
            DataSource dSource = (DataSource)AppUtil.getBean(DataSource.class);
            if (dSource != null) {
                dataSourcesMap.put(localDataSource, dSource);
            }
            return dSource;
        }
        return null;
    }

    public static JdbcTemplateHelper getJdbcTempByDsKey(String key) throws Exception {
        DataSource source = DataSourceUtil.getDataSourceByKey(key);
        if (source == null) {
            return null;
        }
        JdbcTemplateHelper instance = new JdbcTemplateHelper(source);
        return instance;
    }

    public static JdbcTemplateHelper getJdbcTempByDataSource(DataSource source) throws Exception {
        JdbcTemplateHelper instance = new JdbcTemplateHelper(source);
        return instance;
    }

    public static DataSource getNewDruidDataSource(String url, String userName, String password, String driverClassName) throws Exception {
        return DataSourceUtil.getNewDruidDataSource(url, userName, password, driverClassName, 6000, 10, "stat");
    }

    public static DataSource getNewHikariDataSource(String url, String username, String password, String driverClassName, String poolName) throws Exception {
        int minimumidle = 10;
        int idletimeout = 1200000;
        int maximumpoolsize = 10000;
        int maxlifetime = 1800000;
        int connectiontimeout = 30000;
        HikariConfig configuration = new HikariConfig();
        configuration.setJdbcUrl(url);
        configuration.setDriverClassName(driverClassName);
        configuration.setUsername(username);
        configuration.setPassword(password);
        configuration.setMinimumIdle(minimumidle);
        configuration.setIdleTimeout((long)idletimeout);
        configuration.setMaximumPoolSize(maximumpoolsize);
        configuration.setMaxLifetime((long)maxlifetime);
        configuration.setConnectionTimeout((long)connectiontimeout);
        configuration.setPoolName(poolName);
        return DataSourceUtil.getNewHikariDataSource(configuration);
    }

    public static DataSource getNewDruidDataSource(String url, String userName, String password, String driverClassName, int maxWait, int minIdle, String filters) throws Exception {
        Properties props = new Properties();
        props.put("url", url);
        props.put("username", userName);
        props.put("password", password);
        props.put("driverClassName", driverClassName);
        props.put("maxWait", String.valueOf(maxWait));
        props.put("minIdle", String.valueOf(minIdle));
        props.put("filters", filters);
        props.put("connectionErrorRetryAttempts", "0");
        props.put("breakAfterAcquireFailure", (Object)true);
        DruidDataSource druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)props);
        druidDataSource.setBreakAfterAcquireFailure(true);
        druidDataSource.setConnectionErrorRetryAttempts(5);
        return druidDataSource;
    }

    public static DataSource getNewDruidDataSource(String url, String userName, String password, String driverClassName, String filters, String maxActive, String initialSize, String maxWait, boolean testWhileIdle, boolean testOnBorrow, boolean testOnReturn, String validationQuery, boolean poolPreparedStatements, String maxPoolPreparedStatementPerConnectionSize, String timeBetweenEvictionRunsMillis, String minEvictableIdleTimeMillis, int connectionErrorRetryAttempts, boolean breakAfterAcquireFailure) throws Exception {
        Properties props = new Properties();
        props.put("url", url);
        props.put("username", userName);
        props.put("password", password);
        props.put("driverClassName", driverClassName);
        props.put("filters", filters);
        props.put("maxActive", maxActive);
        props.put("initialSize", initialSize);
        props.put("maxWait", maxWait);
        props.put("testWhileIdle", String.valueOf(testWhileIdle));
        props.put("testOnBorrow", String.valueOf(testOnBorrow));
        props.put("testOnReturn", String.valueOf(testOnReturn));
        props.put("validationQuery", validationQuery);
        props.put("poolPreparedStatements", String.valueOf(poolPreparedStatements));
        props.put("maxPoolPreparedStatementPerConnectionSize", maxPoolPreparedStatementPerConnectionSize);
        props.put("timeBetweenEvictionRunsMillis", timeBetweenEvictionRunsMillis);
        props.put("minEvictableIdleTimeMillis", minEvictableIdleTimeMillis);
        if (!breakAfterAcquireFailure) {
            return DruidDataSourceFactory.createDataSource((Properties)props);
        }
        DruidDataSource druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)props);
        druidDataSource.setBreakAfterAcquireFailure(breakAfterAcquireFailure);
        druidDataSource.setConnectionErrorRetryAttempts(connectionErrorRetryAttempts);
        return druidDataSource;
    }

    public static DataSource getNewHikariDataSource(HikariConfig configuration) throws Exception {
        HikariDataSource ds = new HikariDataSource(configuration);
        return ds;
    }

    public static String getDriverClassName(String dbType) {
        switch (dbType) {
            case "mysql_low": {
                return "com.mysql.jdbc.Driver";
            }
            case "mysql": {
                return "com.mysql.cj.jdbc.Driver";
            }
            case "oracle": {
                return "oracle.jdbc.OracleDriver";
            }
            case "sqlserver": 
            case "mssql": {
                return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            }
            case "dm": {
                return "dm.jdbc.driver.DmDriver";
            }
            case "kingbase": {
                return "com.kingbase8.Driver";
            }
            case "oceanbase": {
                return "com.alipay.oceanbase.jdbc.Driver";
            }
            case "postgresql": {
                return "org.postgresql.Driver";
            }
        }
        return "";
    }

    public static String getUrl(String dbType, String ip, String port, String databaseName, String modeName) {
        switch (dbType) {
            case "mysql_low": {
                return "jdbc:mysql://" + ip + ":" + port + "/" + databaseName + "?serverTimezone=UTC&useUnicode=true&characterEncoding=utf-8&useSSL=false&zeroDateTimeBehavior=round&allowMultiQueries=true&autoReconnect=true&failOverReadOnly=false&serverTimezone=Asia/Shanghai";
            }
            case "mysql": {
                return "jdbc:mysql://" + ip + ":" + port + "/" + databaseName + "?serverTimezone=UTC&useUnicode=true&characterEncoding=utf-8&useSSL=false&zeroDateTimeBehavior=round&allowMultiQueries=true&autoReconnect=true&failOverReadOnly=false&serverTimezone=Asia/Shanghai";
            }
            case "oracle": {
                return "jdbc:oracle:thin:@" + ip + ":" + port + ":ORCL";
            }
            case "sqlserver": 
            case "mssql": {
                return "jdbc:sqlserver://" + ip + ":" + port + ";DatabaseName=" + databaseName;
            }
            case "dm": {
                return "jdbc:dm://" + ip + ":" + port + "/" + modeName;
            }
            case "kingbase": {
                return "jdbc:kingbase8://" + ip + ":" + port + "/" + modeName;
            }
            case "postgresql": {
                return "jdbc:postgresql://" + ip + ":" + port + "/" + databaseName;
            }
            case "oceanbase": {
                return "jdbc:oceanbase://" + ip + ":" + port + "/" + databaseName + "?useUnicode=true&characterEncoding=utf-8&rewriteBatchedStatements=true&allowMultiQueries=true";
            }
        }
        return "";
    }
}

