/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.orm.jdbcs;

import com.f2bpm.base.core.utils.CollectionUtil;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.orm.jdbcUtils.ColumnMetaData;
import com.f2bpm.orm.mapper.dialectsql.FactoryDialect;
import com.f2bpm.orm.mapper.dialectsql.IDialectSql;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public class JdbcTemplateHelper {
    private JdbcTemplate jdbcTemplate = null;

    public JdbcTemplateHelper(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public int execute(String sql) throws Exception {
        int n = this.jdbcTemplate.update(sql);
        return n;
    }

    public Object[] getObjectArrParms(String sql, Map<String, Object> parms) {
        sql = this.cleanMyBatistFieldDbType(sql);
        HashMap<String, Integer> parmsOrderNoMap = new HashMap<String, Integer>();
        if (parms != null && parms.size() > 0) {
            for (int whileCount = 0; (sql.indexOf("#{") != -1 || sql.indexOf("${") != -1) && whileCount < 3; ++whileCount) {
                for (String key : parms.keySet()) {
                    String fileName1 = "#{" + key + "}";
                    String fileName2 = "${" + key + "}";
                    String fileName11 = "\\#\\{" + key + "\\}";
                    String fileName22 = "\\$\\{" + key + "\\}";
                    boolean isStrParm = true;
                    int index = sql.indexOf(fileName1);
                    if (index == -1) {
                        isStrParm = false;
                        index = sql.indexOf(fileName2);
                    }
                    if (index == -1) continue;
                    parmsOrderNoMap.put(key + "\u203b" + String.valueOf(index), index);
                    sql = isStrParm ? sql.replaceFirst(fileName11, "XX" + key + "E") : sql.replaceFirst(fileName22, "SS" + key + "E");
                }
            }
        }
        List listEntry = CollectionUtil.MapSortByValue(parmsOrderNoMap, (boolean)false);
        LinkedHashMap mapResult = CollectionUtil.listMapEntryToLinkedHashMap((List)listEntry);
        Object[] arrObjects = new Object[mapResult.size()];
        int i = 0;
        for (String name : mapResult.keySet()) {
            String key = name.split("\u203b")[0];
            arrObjects[i] = parms.get(key);
            ++i;
        }
        return arrObjects;
    }

    public String cleanMyBatistFieldDbType(String sql) {
        ArrayList<String> keysList = new ArrayList<String>();
        keysList.add(",jdbcType=TIMESTAMP");
        keysList.add(",jdbcType=Integer");
        keysList.add(",jdbcType=Boolean");
        keysList.add(",jdbcType=Date");
        keysList.add(",jdbcType=TIMESTAMP");
        keysList.add(",jdbcType=FLOAT");
        keysList.add(",jdbcType=VARCHAR");
        for (String patten : keysList) {
            sql = StringUtil.replaceIgnoreCaseAll((String)sql, (String)patten, (String)"");
        }
        return sql;
    }

    public int executeMyBatisSql(String sql, Map<String, Object> parms) throws Exception {
        Object[] arrObjects = null;
        sql = this.cleanMyBatistFieldDbType(sql);
        if (parms != null && parms.size() > 0) {
            arrObjects = this.getObjectArrParms(sql, parms);
            for (String key : parms.keySet()) {
                String fileName1 = "#{" + key + "}";
                String fileName2 = "${" + key + "}";
                sql = sql.replace(fileName1, "?").replace(fileName2, "?");
            }
        }
        int n = this.update(sql, arrObjects);
        return n;
    }

    public List<Map<String, Object>> queryListForMyBatis(String sql, Map<String, Object> parms) throws Exception {
        Object[] arrObjects = null;
        sql = this.cleanMyBatistFieldDbType(sql);
        if (parms != null && parms.size() > 0) {
            arrObjects = this.getObjectArrParms(sql, parms);
            for (String key : parms.keySet()) {
                String fileName1 = "#{" + key + "}";
                String fileName2 = "${" + key + "}";
                sql = sql.replace(fileName1, "?").replace(fileName2, "?");
            }
        }
        List<Map<String, Object>> list = this.queryForListMap(sql, arrObjects);
        return list;
    }

    public Map<String, Object> queryOneForMyBatis(String sql, Map<String, Object> parms) throws Exception {
        Object[] arrObjects = null;
        sql = this.cleanMyBatistFieldDbType(sql);
        if (parms != null && parms.size() > 0) {
            arrObjects = this.getObjectArrParms(sql, parms);
            for (String key : parms.keySet()) {
                String fileName1 = "#{" + key + "}";
                String fileName2 = "${" + key + "}";
                sql = sql.replace(fileName1, "?").replace(fileName2, "?");
            }
        }
        Map<String, Object> map = this.queryForMap(sql, arrObjects);
        return map;
    }

    public <T> List<T> queryListEntityForMyBatis(String sql, Class<T> classType, Map<String, Object> parms) throws Exception {
        Object[] arrObjects = null;
        sql = this.cleanMyBatistFieldDbType(sql);
        if (parms != null && parms.size() > 0) {
            arrObjects = this.getObjectArrParms(sql, parms);
            for (String key : parms.keySet()) {
                String fileName1 = "#{" + key + "}";
                String fileName2 = "${" + key + "}";
                sql = sql.replace(fileName1, "?").replace(fileName2, "?");
            }
        }
        List<T> result = this.queryForListEntity(sql, classType, arrObjects);
        return result;
    }

    public <T> T queryForEntityMyBatis(String sql, Class<T> classType, Map<String, Object> parms) throws Exception {
        Object[] arrObjects = null;
        sql = this.cleanMyBatistFieldDbType(sql);
        if (parms != null && parms.size() > 0) {
            arrObjects = this.getObjectArrParms(sql, parms);
            for (String key : parms.keySet()) {
                String fileName1 = "#{" + key + "}";
                String fileName2 = "${" + key + "}";
                sql = sql.replace(fileName1, "?").replace(fileName2, "?");
            }
        }
        return this.queryForEntity(sql, classType, arrObjects);
    }

    public int update(String sql, Object ... args) throws Exception {
        int n = this.jdbcTemplate.update(sql, args);
        return n;
    }

    public int updateByMapParm(String sql, Object ... args) throws Exception {
        int n = this.jdbcTemplate.update(sql, args);
        return n;
    }

    public String queryForString(String sql) throws Exception {
        String str = (String)this.jdbcTemplate.queryForObject(sql, String.class);
        return str;
    }

    public int queryForInt(String sql) {
        int str = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        return str;
    }

    public Map<String, Object> queryForMap(String sql, Object ... args) {
        Map result = this.jdbcTemplate.queryForMap(sql, args);
        return result;
    }

    public List<Map<String, Object>> queryForListMap(String sql, Object ... args) {
        List result = this.jdbcTemplate.queryForList(sql, args);
        return result;
    }

    public <T> T queryForEntity(String sql, Class<T> classType, Object ... args) throws Exception {
        Map map = this.jdbcTemplate.queryForMap(sql, args);
        if (map == null || map.keySet().size() == 0) {
            return null;
        }
        Object result = CollectionUtil.MapToEntity((Map)map, classType);
        return (T)result;
    }

    public <T> List<T> queryForListEntity(String sql, Class<T> classType, Object ... args) throws Exception {
        List listMap = this.jdbcTemplate.queryForList(sql, args);
        if (listMap == null || listMap.size() == 0) {
            return null;
        }
        List result = CollectionUtil.listMapToListEntity((List)listMap, classType);
        return result;
    }

    public <T> List<T> queryForList(String sql, RowMapper<T> rowMapper) throws Exception {
        List result = this.jdbcTemplate.query(sql, rowMapper);
        return result;
    }

    public List<ColumnMetaData> getSchemaByTableName(String tableName, String dalType) {
        String sql = "SELECT * FROM " + tableName;
        return this.getSchemaBySql(sql, dalType);
    }

    public List<ColumnMetaData> getSchemaBySql(String sql, String dalType) {
        IDialectSql dialect = FactoryDialect.getDialect((String)dalType);
        String sqlTop = dialect.getTopSql(sql, 0);
        SqlRowSet sqlRowSet = this.jdbcTemplate.queryForRowSet(sqlTop);
        LinkedList<ColumnMetaData> columneMetaList = new LinkedList<ColumnMetaData>();
        SqlRowSetMetaData sqlRowSetMetaData = sqlRowSet.getMetaData();
        int columnCount = sqlRowSetMetaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            columneMetaList.add(new ColumnMetaData(sqlRowSetMetaData.getColumnName(i), sqlRowSetMetaData.getTableName(i), sqlRowSetMetaData.getColumnType(i), sqlRowSetMetaData.getColumnTypeName(i)));
        }
        return columneMetaList;
    }
}

