/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.orm.mapper;

import com.f2bpm.base.core.app.AppConfig;
import com.f2bpm.base.core.utils.CollectionUtil;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.orm.mapper.AbstractMyBatisImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.transaction.annotation.Transactional;

public abstract class MyBatisImpl<PK extends Serializable, T extends Serializable>
extends AbstractMyBatisImpl<PK, T> {
    @Resource(name="f2bpmSqlSessionTemplate")
    protected SqlSessionTemplate f2bpmSqlSessionTemplate;
    @Resource(name="orgimpl_f2bpmSqlSessionTemplate")
    protected SqlSessionTemplate orgimpl_f2bpmSqlSessionTemplate;
    protected static final String Key_isexist = "isexist";
    protected static final String Key_Insert = "insert";
    protected static final String Key_Update = "update";
    protected static final String Key_Delete = "delete";
    protected static final String Key_DeleteList = "deleteByList";
    protected static final String Key_SingleColumn = "singleColumn";
    protected static final String Key_Select = "select";
    protected static final String Key_GetModel = "select";

    protected boolean getOrgImplIsSeparation() {
        return AppConfig.getBoolApp((String)"f2bpm.orgimpl.dbseparation");
    }

    public String getDbType() {
        String dbType = AppConfig.getDbType();
        return dbType;
    }

    public String getDbName() {
        String dbType = AppConfig.getDbName();
        return dbType;
    }

    public abstract String getNamespace();

    public boolean insert(T entity) {
        return this.f2bpmSqlSessionTemplate.insert(this.getNamespace() + "." + Key_Insert, entity) > 0;
    }

    public boolean insert_Ex(T entity) {
        return this.orgimpl_f2bpmSqlSessionTemplate.insert(this.getNamespace() + "." + Key_Insert, entity) > 0;
    }

    public boolean create(T entity) {
        return this.f2bpmSqlSessionTemplate.insert(this.getNamespace() + "." + Key_Insert, entity) > 0;
    }

    public boolean create_Ex(T entity) {
        return this.orgimpl_f2bpmSqlSessionTemplate.insert(this.getNamespace() + "." + Key_Insert, entity) > 0;
    }

    public boolean isExist(String fieldName, String fieldValue) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("FieldName", fieldName);
        params.put("FieldValue", fieldValue);
        Object object = this.f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + Key_isexist, params);
        return (Integer)object > 0;
    }

    public boolean isExist_Ex(String fieldName, String fieldValue) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("FieldName", fieldName);
        params.put("FieldValue", fieldValue);
        Object object = this.orgimpl_f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + Key_isexist, params);
        return (Integer)object > 0;
    }

    public boolean isExist(String sqlkey, Map<String, Object> param) {
        Object object = this.f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + sqlkey, param);
        return (Integer)object > 0;
    }

    public boolean isExist_Ex(String sqlkey, Map<String, Object> param) {
        Object object = this.orgimpl_f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + sqlkey, param);
        return (Integer)object > 0;
    }

    public boolean update(T entity) {
        boolean success = this.f2bpmSqlSessionTemplate.update(this.getNamespace() + "." + Key_Update, entity) > 0;
        return success;
    }

    public boolean update_Ex(T entity) {
        boolean success = this.orgimpl_f2bpmSqlSessionTemplate.update(this.getNamespace() + "." + Key_Update, entity) > 0;
        return success;
    }

    public boolean delete(PK entityId) {
        return this.f2bpmSqlSessionTemplate.delete(this.getNamespace() + "." + Key_Delete, entityId) > 0;
    }

    public boolean delete_Ex(PK entityId) {
        return this.orgimpl_f2bpmSqlSessionTemplate.delete(this.getNamespace() + "." + Key_Delete, entityId) > 0;
    }

    public T getModel(PK entityId) {
        HashMap<String, PK> params = new HashMap<String, PK>();
        params.put("PK", entityId);
        Serializable selectOne = (Serializable)this.f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + "select", params);
        return (T)selectOne;
    }

    public T getModel_Ex(PK entityId) {
        HashMap<String, PK> params = new HashMap<String, PK>();
        params.put("PK", entityId);
        Serializable selectOne = (Serializable)this.orgimpl_f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + "select", params);
        return (T)selectOne;
    }

    public T getSingleColumnSingleRow(String columnName, String entityId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PK", entityId);
        params.put("ColumnName", columnName);
        Serializable selectOne = (Serializable)this.f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + Key_SingleColumn, params);
        return (T)selectOne;
    }

    public T getSingleColumnSingleRow_Ex(String columnName, String entityId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PK", entityId);
        params.put("ColumnName", columnName);
        Serializable selectOne = (Serializable)this.orgimpl_f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + Key_SingleColumn, params);
        return (T)selectOne;
    }

    public T getModel(Map<String, Object> params) {
        Serializable selectOne = (Serializable)this.f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + "select", params);
        return (T)selectOne;
    }

    public T getModel_Ex(Map<String, Object> params) {
        Serializable selectOne = (Serializable)this.orgimpl_f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + "select", params);
        return (T)selectOne;
    }

    @Transactional
    public int deleteByIds(PK ... ids) {
        ArrayList<String> listIds = new ArrayList<String>();
        if (ids != null) {
            for (PK pk : ids) {
                listIds.add(pk.toString());
            }
        }
        return this.deleteByList(listIds);
    }

    public int deleteByIds_Ex(PK ... ids) {
        ArrayList<String> listIds = new ArrayList<String>();
        if (ids != null) {
            for (PK pk : ids) {
                listIds.add(pk.toString());
            }
        }
        return this.deleteByList_Ex(listIds);
    }

    @Transactional
    public int deleteByList(List<String> listIds) {
        if (CollectionUtil.isNullOrWhiteSpace(listIds)) {
            return 0;
        }
        String ids = CollectionUtil.list2StringAndSinglequote(listIds);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("listStringID", ids);
        return this.f2bpmSqlSessionTemplate.delete(this.getNamespace() + "." + Key_DeleteList, map);
    }

    public int deleteByList_Ex(List<String> listIds) {
        String ids = CollectionUtil.list2StringAndSinglequote(listIds);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("listStringID", ids);
        return this.orgimpl_f2bpmSqlSessionTemplate.delete(this.getNamespace() + "." + Key_DeleteList, map);
    }

    public List<T> getAll() {
        return this.f2bpmSqlSessionTemplate.selectList(this.getNamespace() + "." + "select", null);
    }

    public List<T> getAllByTenantId(String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TenantId", tenantId);
        return this.f2bpmSqlSessionTemplate.selectList(this.getNamespace() + "." + "select", params);
    }

    public List<T> getAll_Ex() {
        return this.orgimpl_f2bpmSqlSessionTemplate.selectList(this.getNamespace() + "." + "select", null);
    }

    public List<T> getAll_Ex(String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TenantId", tenantId);
        return this.orgimpl_f2bpmSqlSessionTemplate.selectList(this.getNamespace() + "." + "select", params);
    }

    public T getUnique(String sqlKey, Map<String, Object> params) {
        return (T)((Serializable)this.f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + sqlKey, params));
    }

    public T getUnique_Ex(String sqlKey, Map<String, Object> params) {
        return (T)((Serializable)this.orgimpl_f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + sqlKey, params));
    }

    public T getUnique(String sql) {
        HashMap<String, String> htMap = new HashMap<String, String>();
        htMap.put("sql", sql);
        return (T)((Serializable)this.f2bpmSqlSessionTemplate.selectOne("com.f2bpm.sql.common.query", htMap));
    }

    public T getUnique_Ex(String sql) {
        HashMap<String, String> htMap = new HashMap<String, String>();
        htMap.put("sql", sql);
        return (T)((Serializable)this.orgimpl_f2bpmSqlSessionTemplate.selectOne("com.f2bpm.sql.common.query", htMap));
    }

    public T getUnique(String sqlKey, Object params) {
        return (T)((Serializable)this.f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + sqlKey, params));
    }

    public T getUnique_Ex(String sqlKey, Object params) {
        return (T)((Serializable)this.orgimpl_f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + sqlKey, params));
    }

    public Object getOne(String sqlKey, Object params) {
        return this.f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + sqlKey, params);
    }

    public Object getOne_Ex(String sqlKey, Object params) {
        return this.orgimpl_f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + sqlKey, params);
    }

    public Object getOne(String sqlKey, Map<String, Object> params) {
        return this.f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + sqlKey, params);
    }

    public Object getOne_Ex(String sqlKey, Map<String, Object> params) {
        return this.orgimpl_f2bpmSqlSessionTemplate.selectOne(this.getNamespace() + "." + sqlKey, params);
    }

    public List<T> getList(String sqlKey, Map<String, Object> params) {
        return this.f2bpmSqlSessionTemplate.selectList(this.getNamespace() + "." + sqlKey, params);
    }

    public List<T> getList_Ex(String sqlKey, Map<String, Object> params) {
        return this.orgimpl_f2bpmSqlSessionTemplate.selectList(this.getNamespace() + "." + sqlKey, params);
    }

    public List<T> getListByFullKey(String sqlFullKey, Map<String, Object> params) {
        return this.f2bpmSqlSessionTemplate.selectList(sqlFullKey, params);
    }

    public List<T> getListByFullKey_Ex(String sqlFullKey, Map<String, Object> params) {
        return this.orgimpl_f2bpmSqlSessionTemplate.selectList(sqlFullKey, params);
    }

    public List getEntityList(String sqlKey, Map<String, Object> params) {
        return this.f2bpmSqlSessionTemplate.selectList(this.getNamespace() + "." + sqlKey, params);
    }

    public List getEntityList_Ex(String sqlKey, Map<String, Object> params) {
        return this.orgimpl_f2bpmSqlSessionTemplate.selectList(this.getNamespace() + "." + sqlKey, params);
    }

    public List<T> getList(String sqlKey, Object param) {
        return this.f2bpmSqlSessionTemplate.selectList(this.getNamespace() + "." + sqlKey, param);
    }

    public List<T> getList_Ex(String sqlKey, Object param) {
        return this.orgimpl_f2bpmSqlSessionTemplate.selectList(this.getNamespace() + "." + sqlKey, param);
    }

    public int updateByKey(String sqlKey, Map<String, Object> params) {
        return this.f2bpmSqlSessionTemplate.update(this.getNamespace() + "." + sqlKey, params);
    }

    public int updateByKey_Ex(String sqlKey, Map<String, Object> params) {
        return this.orgimpl_f2bpmSqlSessionTemplate.update(this.getNamespace() + "." + sqlKey, params);
    }

    public int updateByKey(String sqlKey, Object params) {
        return this.f2bpmSqlSessionTemplate.update(this.getNamespace() + "." + sqlKey, params);
    }

    public int updateByKey_Ex(String sqlKey, Object params) {
        return this.orgimpl_f2bpmSqlSessionTemplate.update(this.getNamespace() + "." + sqlKey, params);
    }

    public int updateByKey(String sqlKey) {
        return this.f2bpmSqlSessionTemplate.update(this.getNamespace() + "." + sqlKey);
    }

    public int updateByKey_Ex(String sqlKey) {
        return this.orgimpl_f2bpmSqlSessionTemplate.update(this.getNamespace() + "." + sqlKey);
    }

    public int insertByKey(String sqlKey, Object params) {
        return this.f2bpmSqlSessionTemplate.insert(this.getNamespace() + "." + sqlKey, params);
    }

    public int insertByKey_Ex(String sqlKey, Object params) {
        return this.orgimpl_f2bpmSqlSessionTemplate.insert(this.getNamespace() + "." + sqlKey, params);
    }

    public int deleteByKey(String sqlKey, Map<String, Object> params) {
        return this.f2bpmSqlSessionTemplate.delete(this.getNamespace() + "." + sqlKey, params);
    }

    public int deleteByKey_Ex(String sqlKey, Map<String, Object> params) {
        return this.orgimpl_f2bpmSqlSessionTemplate.delete(this.getNamespace() + "." + sqlKey, params);
    }

    public int deleteByKey(String sqlKey, Object params) {
        return this.f2bpmSqlSessionTemplate.delete(this.getNamespace() + "." + sqlKey, params);
    }

    public int deleteByKey_Ex(String sqlKey, Object params) {
        return this.orgimpl_f2bpmSqlSessionTemplate.delete(this.getNamespace() + "." + sqlKey, params);
    }

    public int deleteByKey(String sqlKey) {
        return this.f2bpmSqlSessionTemplate.delete(this.getNamespace() + "." + sqlKey);
    }

    public int deleteByKey_Ex(String sqlKey) {
        return this.orgimpl_f2bpmSqlSessionTemplate.delete(this.getNamespace() + "." + sqlKey);
    }

    public Map<String, Object> buildMap(String paramName, Object paramValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(paramName, paramValue);
        return map;
    }

    protected MapBuilder buildMapBuilder() {
        return new MapBuilder();
    }

    public SqlSessionTemplate getSqlSessionTemplate() {
        return this.f2bpmSqlSessionTemplate;
    }

    public SqlSessionTemplate getSqlSessionTemplate_Ex() {
        return this.orgimpl_f2bpmSqlSessionTemplate;
    }

    public String getJdbcType() {
        String dbType = AppConfig.getDbType();
        if (StringUtil.isNotEmpty((String)dbType)) {
            return dbType;
        }
        return AppConfig.getJdbcType();
    }

    protected class MapBuilder {
        Map<String, Object> map = new HashMap<String, Object>();

        protected MapBuilder() {
        }

        public MapBuilder addParam(String paramKey, Object paramValue) {
            this.map.put(paramKey, paramValue);
            return this;
        }

        public Map<String, Object> getParams() {
            return this.map;
        }
    }
}

