/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.orm.pager;

import com.f2bpm.base.core.app.AppConfig;
import com.f2bpm.base.core.entity.MyInteger;
import com.f2bpm.base.core.enums.DalType;
import com.f2bpm.base.core.utils.BaseLog;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.orm.jdbcs.JdbcTemplateHelper;
import com.f2bpm.orm.mapper.MapperDbHelper;
import com.f2bpm.orm.pager.OrgImplPagerForwardHelper;
import java.util.List;

public class MssqlPagerHelper {
    public static <T> List<T> getListByPage(boolean isEx, int page, int pageSize, String tableName, String fields, String sqlContent, String strWhere, String orderby, MyInteger numCount, MyInteger pageCount, JdbcTemplateHelper sqlHelper) {
        String orgImplDbType = AppConfig.getOrgImplDbType();
        if (isEx && !orgImplDbType.equalsIgnoreCase(DalType.mssql.toString())) {
            return OrgImplPagerForwardHelper.getListByPage(orgImplDbType, page, pageSize, tableName, fields, sqlContent, strWhere, orderby, numCount, pageCount, sqlHelper);
        }
        String t_tableName = tableName;
        String t_strWhere = strWhere;
        String t_orderby = orderby;
        String t_sqlContent = sqlContent;
        String cutomSql = "";
        String strSql = "";
        int startIndex = 0;
        int endIndex = 0;
        if (page <= 0) {
            page = 1;
        }
        strSql = "select count(0) from " + t_tableName;
        if (StringUtil.isNotEmpty((String)t_strWhere)) {
            strSql = strSql + " where " + t_strWhere;
        }
        if (StringUtil.isNotEmpty((String)t_sqlContent) && StringUtil.isNotEmpty((String)t_strWhere)) {
            strSql = "select count(0) from (" + t_sqlContent + " where " + t_strWhere + ") as _view";
        }
        if (StringUtil.isNotEmpty((String)t_sqlContent) && StringUtil.isEmpty((String)t_strWhere)) {
            strSql = "select count(0) from (" + t_sqlContent + ") as _view";
        }
        int total = sqlHelper != null ? sqlHelper.queryForInt(strSql) : MapperDbHelper.getCountBySql(strSql, isEx);
        int _pageCount = 0;
        numCount.setValue(total);
        _pageCount = total % pageSize == 0 ? total / pageSize : (total - total % pageSize) / pageSize + 1;
        pageCount.setValue(_pageCount);
        startIndex = (page - 1) * pageSize + 1;
        endIndex = page * pageSize;
        String topRowNumSql = " top " + endIndex + " row_number() over(order by " + t_orderby + " ) rownum,";
        cutomSql = "select " + topRowNumSql + fields + " from " + tableName + " where 1=1";
        if (StringUtil.isNotEmpty((String)t_sqlContent)) {
            int selectIndex = t_sqlContent.toLowerCase().indexOf("select ");
            cutomSql = "select " + topRowNumSql + " " + t_sqlContent.substring(selectIndex + 7);
            if (cutomSql.toLowerCase().indexOf("where") == -1) {
                cutomSql = cutomSql + " where 1=1";
            }
        }
        if (StringUtil.isNotEmpty((String)t_strWhere)) {
            cutomSql = cutomSql + " and " + t_strWhere;
        }
        strSql = "select t.* from (" + cutomSql + ") as t where t.rownum between  " + startIndex + " and " + endIndex;
        if (sqlHelper != null) {
            try {
                return sqlHelper.queryForListMap(strSql, new Object[0]);
            }
            catch (Exception e) {
                BaseLog.writeDebugLog((String)e.toString());
                return null;
            }
        }
        return isEx ? MapperDbHelper.getListMapBySql_Ex(strSql) : MapperDbHelper.getListMapBySql(strSql);
    }
}

