/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.utils;

import com.f2bpm.base.core.app.AppConfig;
import com.f2bpm.base.core.enums.DalType;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.orm.mapper.MapperDbHelper;

public class TableStructureUtil {
    public static boolean copyTableStructure(String dbTableName, String saveAsName) {
        String dbType = AppConfig.getDbType();
        String mysql_copyTableStruct = "create table " + saveAsName + " like  " + dbTableName;
        String oracle_copyTableStruct = "create table " + saveAsName + " as select * from " + dbTableName + "  where 1=2";
        String postgresql_copyTableStruct = "create table " + saveAsName + " as  ( select * from " + dbTableName + " limit 0)";
        if (dbType.equalsIgnoreCase(DalType.mysql.toString())) {
            MapperDbHelper.execute(mysql_copyTableStruct);
        } else if (dbType.equalsIgnoreCase(DalType.oracle.toString())) {
            MapperDbHelper.execute(oracle_copyTableStruct);
        } else if (dbType.equalsIgnoreCase(DalType.postgresql.toString())) {
            MapperDbHelper.execute(postgresql_copyTableStruct);
        }
        return true;
    }

    public static boolean copyTableStructureAndData(String dbTableName, String saveAsName) {
        String dbType = AppConfig.getDbType();
        String mssql_copyTableStructAndData = "select * into   " + saveAsName + " from  " + dbTableName;
        String mysql_copyTableStruct = "create table " + saveAsName + " like  " + dbTableName;
        String oracle_copyTableStruct = "create table " + saveAsName + " as select * from " + dbTableName;
        if (dbType.equalsIgnoreCase(DalType.mysql.toString())) {
            MapperDbHelper.execute(mysql_copyTableStruct);
            String mysql_copyData = "INSERT  INTO    " + saveAsName + " select * from   " + dbTableName;
            MapperDbHelper.execute(mysql_copyData);
        } else if (dbType.equalsIgnoreCase(DalType.oracle.toString())) {
            MapperDbHelper.execute(oracle_copyTableStruct);
        } else if (dbType.equalsIgnoreCase(DalType.mssql.toString())) {
            MapperDbHelper.execute(mssql_copyTableStructAndData);
        }
        return true;
    }

    public static boolean modifyTableName(String dalType, String oldTableName, String newTableName) {
        String sql = "";
        sql = dalType.equalsIgnoreCase(DalType.mysql.toString()) ? StringUtil.format((String)"ALTER TABLE {0} RENAME TO {1}", (Object[])new Object[]{oldTableName, newTableName}) : (dalType.equalsIgnoreCase(DalType.oracle.toString()) ? StringUtil.format((String)"ALTER TABLE {0} RENAME TO {1}", (Object[])new Object[]{oldTableName, newTableName}) : StringUtil.format((String)"ALTER TABLE {0} RENAME TO {1}", (Object[])new Object[]{oldTableName, newTableName}));
        MapperDbHelper.execute(sql);
        return true;
    }

    public static boolean isExistTable(DalType dalType, String dbName, String tableName) {
        boolean isExist = false;
        String sql = "";
        sql = dalType.equals((Object)DalType.mysql) ? StringUtil.format((String)"SELECT count(0) FROM information_schema.TABLES WHERE  table_schema='{0}' and table_name ='{1}' ", (Object[])new Object[]{dbName, tableName}) : (dalType.equals((Object)DalType.oracle) ? StringUtil.format((String)"SELECT COUNT(0) FROM User_Tables WHERE upper(table_name) =upper('{0}')", (Object[])new Object[]{tableName}) : StringUtil.format((String)"SELECT COUNT(0) FROM User_Tables WHERE upper(table_name) =upper('{0}')", (Object[])new Object[]{tableName}));
        isExist = MapperDbHelper.executeExist(sql, null);
        return isExist;
    }
}

