/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.system.admin.impl.services;

import com.f2bpm.base.core.app.AppConfig;
import com.f2bpm.base.core.entity.MyInteger;
import com.f2bpm.base.core.utils.AppUtil;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.base.core.utils.time.DateUtil;
import com.f2bpm.orm.mapper.MapperDbHelper;
import com.f2bpm.orm.mapper.MyBatisImpl;
import com.f2bpm.system.admin.impl.api.ILoginLogService;
import com.f2bpm.system.admin.impl.model.LoginLog;
import com.f2bpm.system.security.enums.SystemStatusObjCode;
import com.f2bpm.system.security.impl.iservices.ISystemStatusService;
import com.f2bpm.utils.TableStructureUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="loginLogService")
public class LoginLogService
extends MyBatisImpl<String, LoginLog>
implements ILoginLogService {
    private static final Object lockCreateLogByYear = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createLogByYear(LoginLog log) {
        String loginLogTableYear = "2022";
        String loginLogTableName = "sys_loginlog";
        String currentYear = DateUtil.formatDate((Date)log.getCreatedTime(), (Object[])new Object[]{"yyyy"});
        if (StringUtil.isNotEmpty((String)loginLogTableYear) && !currentYear.equalsIgnoreCase(loginLogTableYear)) {
            Object object = lockCreateLogByYear;
            synchronized (object) {
                String objCode = SystemStatusObjCode.loginLogTableYear.toString();
                String tenantId = "System";
                String dbType = AppConfig.getDbType();
                String oldTableName = loginLogTableName;
                String newTableName = loginLogTableName + "_" + loginLogTableYear;
                TableStructureUtil.modifyTableName((String)dbType, (String)oldTableName, (String)newTableName);
                TableStructureUtil.copyTableStructure((String)newTableName, (String)loginLogTableName);
                ((ISystemStatusService)AppUtil.getBean(ISystemStatusService.class)).updateCurrentValueByObjCodeTenantId(currentYear, objCode, tenantId);
            }
        }
        this.updateByKey("insert", (Object)log);
    }

    @Override
    public int updateLogoutTime(String serialNumber) {
        HashMap<String, Object> ht = new HashMap<String, Object>();
        ht.put("LogoutTime", new Date());
        ht.put("SerialNumber", serialNumber);
        int n = this.updateByKey("sys_LoginLog_UpdateLogoutTime", ht);
        return n;
    }

    @Override
    public int updateLoginDateToDisabled(String userName, String loginDate, String newLoginDate, String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("LoginDate", loginDate);
        ht.put("NewLoginDate", newLoginDate);
        ht.put("TenantId", tenantId);
        ht.put("UserName", userName);
        int n = this.updateByKey("sys_LoginLog_UpdateLoginDate", ht);
        return n;
    }

    @Override
    public Integer getFailLoginTimes(String userName, String loginDate, String tenantId) {
        HashMap<String, Object> ht = new HashMap<String, Object>();
        ht.put("UserName", userName);
        ht.put("LoginDate", loginDate);
        ht.put("TenantId", tenantId);
        ht.put("Status", 0);
        return (Integer)this.getOne("getErrorLoginTimes", ht);
    }

    @Override
    public List<LoginLog> getFailLoginByUserNameLoginDate(String userName, String loginDate, String tenantId) {
        HashMap<String, Object> ht = new HashMap<String, Object>();
        ht.put("UserName", userName);
        ht.put("LoginDate", loginDate);
        ht.put("TenantId", tenantId);
        ht.put("Status", 0);
        return this.getList("select", ht);
    }

    public List<LoginLog> getListByPage(String whereStr, String strOrderBy, int pageIndex, int pageSize, MyInteger recordCount, MyInteger pagesCount, Integer doCount) {
        return MapperDbHelper.getListEntityByProPageQuery((String)"sys_LoginLog", (String)"*", (String)strOrderBy, (String)whereStr, (int)pageIndex, (int)pageSize, (MyInteger)recordCount, (MyInteger)pagesCount, (int)doCount, LoginLog.class);
    }

    public String getNamespace() {
        return LoginLog.class.getName();
    }
}

