/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.system.admin.impl.services;

import com.f2bpm.base.core.entity.MyInteger;
import com.f2bpm.base.core.entity.TreeNode;
import com.f2bpm.base.core.enums.CodeEnum;
import com.f2bpm.base.core.enums.DalType;
import com.f2bpm.base.core.utils.CollectionUtil;
import com.f2bpm.base.core.utils.Guid;
import com.f2bpm.base.core.utils.JsonHelper;
import com.f2bpm.base.core.utils.TreeNodeHelper;
import com.f2bpm.orm.mapper.MapperDbHelper;
import com.f2bpm.orm.mapper.MyBatisImpl;
import com.f2bpm.process.org.api.enums.TableKeyEnum;
import com.f2bpm.process.org.factory.OrganizationConfigFactory;
import com.f2bpm.system.admin.impl.api.IOrganizationService;
import com.f2bpm.system.admin.impl.model.Organization;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="organizationService")
public class OrganizationService
extends MyBatisImpl<String, Organization>
implements IOrganizationService {
    @Override
    public boolean isExistOrgName(String tenantId, String orgName) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("TenantId", tenantId);
        ht.put("OrgName", orgName);
        Object n = this.getOne("isExistOrgName", ht);
        return (Integer)n > 0;
    }

    @Override
    public boolean isExistOrgId(String tenantId, String orgId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("TenantId", tenantId);
        ht.put("OrgId", orgId);
        Object n = this.getOne("isExistOrgId", ht);
        return (Integer)n > 0;
    }

    @Override
    public int deleteByOrgIdTenantId(String orgId, String tenantId) {
        int n = 0;
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("OrgId", orgId);
        ht.put("TenantId", tenantId);
        n = this.deleteByKey("deleteByOrgIdTenantId", ht);
        return n;
    }

    @Override
    public int deleteAndAllSubsOrgByOrgId(String tenantId, String orgId) {
        int n = 0;
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("OrgId", orgId);
        ht.put("TenantId", tenantId);
        List<Organization> allOrgList = this.getAllOrgList(tenantId);
        ArrayList listResult = new ArrayList();
        CollectionUtil.getChildList(allOrgList, (String)orgId, (boolean)true, (String)"orgId", (String)"parentOrgId", listResult);
        List listOrgIds = CollectionUtil.listT2ListString(listResult, (String)"orgId");
        n = this.deleteByList(listOrgIds);
        return n;
    }

    public List<Organization> getAllOrgList(String tenantId) {
        Map ht = OrganizationConfigFactory.getConfigMapByTableKey((String)TableKeyEnum.Table_sys_Organization.toString());
        ht.put("TenantId", tenantId);
        return this.getList("select", ht);
    }

    @Override
    public boolean deleteByTenantId(String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TenantId", tenantId);
        return this.deleteByKey("deleteByTenantId", params) > 0;
    }

    @Override
    public int deleteAndAllSubsOrgByList(String tenantId, List<String> listStringID) {
        int n = 0;
        for (String orgId : listStringID) {
            this.deleteAndAllSubsOrgByOrgId(tenantId, orgId);
        }
        return n;
    }

    @Override
    public Organization getModelByDpName(String tenantId, String orgName) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("TenantId", tenantId);
        ht.put("OrgName", orgName);
        return (Organization)((Object)this.getUnique("select", ht));
    }

    @Override
    public Organization getModelByOrgId(String tenantId, String orgId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("TenantId", tenantId);
        ht.put("OrgId", orgId);
        return (Organization)((Object)this.getUnique("select", ht));
    }

    @Override
    public Organization getModelById(String id) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("Id", id);
        return (Organization)((Object)this.getUnique("select", ht));
    }

    @Override
    public String getDepartmentPathName(String dpId, boolean IsHaveYouself) {
        String DirNameStr = "";
        Organization department = (Organization)((Object)this.getModel((Serializable)((Object)dpId)));
        if (IsHaveYouself) {
            DirNameStr = DirNameStr + department.getOrgName();
        }
        while (!Guid.getEmpty().equals(department.getParentOrgId())) {
            department = (Organization)((Object)this.getModel((Serializable)((Object)department.getParentOrgId())));
            DirNameStr = DirNameStr + "," + department.getOrgName().trim();
        }
        StringBuilder FDirName = new StringBuilder();
        String[] dirnameStr = DirNameStr.split("[,]", -1);
        int n = dirnameStr.length;
        for (int i = n - 1; i >= 0; --i) {
            if (dirnameStr[i].trim().length() > 0 && i != 0) {
                FDirName.append(dirnameStr[i].toString().trim());
                FDirName.append("=>");
                continue;
            }
            if (dirnameStr[i].trim().length() <= 0) continue;
            FDirName.append(dirnameStr[i].toString().trim());
        }
        return FDirName.toString();
    }

    @Override
    public List<Organization> getOrganizationAndAllSubOrganization(String tenantId, String orgId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("OrgId", orgId);
        ht.put("TenantId", tenantId);
        if (this.getDbType().equals(DalType.mysql.toString())) {
            List<Organization> allOrgList = this.getAllOrgList(tenantId);
            ArrayList<Organization> listResult = new ArrayList<Organization>();
            CollectionUtil.getChildList(allOrgList, (String)orgId, (boolean)true, (String)"orgId", (String)"parentOrgId", listResult);
            return listResult;
        }
        return this.getList(this.getDbType() + "_sys_Organization_SelectOrganizationAndAllSubOrganization", ht);
    }

    @Override
    public List<Organization> getListByTenantId(String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("TenantId", tenantId);
        return this.getList("select", ht);
    }

    @Override
    public List<Organization> getChilredDepartmentsByParentId(String parentOrgId, String tenantId) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("ParentOrgId", parentOrgId);
        dic.put("TenantId", tenantId);
        return this.getList("select", dic);
    }

    public List<Organization> getListByPage(String strOrderBy, String whereStr, int pageIndex, int pageSize, MyInteger recordCount, MyInteger pagesCount, Integer doCount) {
        return MapperDbHelper.getListEntityByProPageQuery((String)"sys_Organization", (String)"*", (String)strOrderBy, (String)whereStr, (int)pageIndex, (int)pageSize, (MyInteger)recordCount, (MyInteger)pagesCount, (int)doCount, Organization.class);
    }

    @Override
    public String getJsonNodes(boolean isDefaultColsed) {
        TreeNode node;
        List data = this.getAll();
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        for (Organization d : data) {
            node = new TreeNode();
            node.setId(d.getOrgId());
            node.setPid(d.getParentOrgId());
            node.setText(d.getOrgName());
            node.setState(isDefaultColsed ? "closed" : "open");
            list.add(node);
        }
        node = new TreeNode();
        node.setId("Root");
        node.setPid("");
        node.setText("\u7cfb\u7edf\u6839\u7ed3\u70b9");
        list.add(node);
        TreeNodeHelper treeNodeHelper = new TreeNodeHelper();
        String jsonTree = "";
        jsonTree = treeNodeHelper.generateTreeRoot(list).toJsonTreeString();
        return JsonHelper.outDataArrResult((boolean)true, (String)"", (String)jsonTree, (CodeEnum)CodeEnum.success);
    }

    @Override
    public String getJsonNodes(boolean isDefaultColsed, String tenantId) {
        TreeNode node;
        List<Organization> data = this.getListByTenantId(tenantId);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        for (Organization d : data) {
            node = new TreeNode();
            node.setId(d.getOrgId());
            node.setPid(d.getParentOrgId());
            node.setText(d.getOrgName());
            node.setState(isDefaultColsed ? "closed" : "open");
            list.add(node);
        }
        node = new TreeNode();
        node.setId("Root");
        node.setPid("");
        node.setText("\u7cfb\u7edf\u6839\u7ed3\u70b9");
        list.add(node);
        TreeNodeHelper treeNodeHelper = new TreeNodeHelper();
        String jsonTree = "";
        jsonTree = treeNodeHelper.generateTreeRoot(list).toJsonTreeString();
        return JsonHelper.outDataArrResult((boolean)true, (String)"", (String)jsonTree, (CodeEnum)CodeEnum.success);
    }

    public String getNamespace() {
        return Organization.class.getName();
    }
}

