/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.system.admin.impl.services;

import com.f2bpm.base.core.entity.MyInteger;
import com.f2bpm.orm.mapper.MapperDbHelper;
import com.f2bpm.orm.mapper.MyBatisImpl;
import com.f2bpm.system.admin.impl.api.IPositionService;
import com.f2bpm.system.admin.impl.model.Position;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="positionService")
public class PositionService
extends MyBatisImpl<String, Position>
implements IPositionService {
    @Override
    public boolean isExisPostName(String postName, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("postName", postName);
        return this.isExist("isExistPostName", params);
    }

    @Override
    public boolean isExisPostCode(String postCode, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("postCode", postCode);
        return this.isExist("isExistPostCode", params);
    }

    @Override
    public boolean isExistByJobCode(String jobCode, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("jobCode", jobCode);
        return this.isExist("isExistByJobCode", params);
    }

    @Override
    public Position getPositionInfoByPostCode(String postCode, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("postCode", postCode);
        return (Position)((Object)this.getUnique("select_position_org_job", params));
    }

    @Override
    public Position getModelById(String id, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("id", id);
        return (Position)((Object)this.getUnique("select", params));
    }

    @Override
    public Position getModelByPostCode(String postCode, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("postCode", postCode);
        return (Position)((Object)this.getUnique("select", params));
    }

    @Override
    public Position getPositionInfoById(String id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        return (Position)((Object)this.getUnique("select_position_org_job", params));
    }

    public List<Position> getListByPage(String whereStr, String strOrderBy, int pageIndex, int pageSize, MyInteger recordCount, MyInteger pagesCount, Integer doCount) {
        return MapperDbHelper.getListByProPageQuery((String)"sys_position", (String)"*", (String)"", (String)strOrderBy, (String)whereStr, (int)pageIndex, (int)pageSize, (MyInteger)recordCount, (MyInteger)pagesCount, (int)doCount, Position.class);
    }

    public String getNamespace() {
        return Position.class.getName();
    }
}

