/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.system.admin.impl.services;

import com.f2bpm.base.core.entity.MyInteger;
import com.f2bpm.base.core.entity.TreeNode;
import com.f2bpm.base.core.enums.CodeEnum;
import com.f2bpm.base.core.utils.JsonHelper;
import com.f2bpm.base.core.utils.TreeNodeHelper;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.orm.mapper.MapperDbHelper;
import com.f2bpm.orm.mapper.MyBatisImpl;
import com.f2bpm.system.admin.impl.api.IPostJobService;
import com.f2bpm.system.admin.impl.model.PostJob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="postJobService")
public class PostJobService
extends MyBatisImpl<String, PostJob>
implements IPostJobService {
    @Override
    public boolean isExisPostJobName(String jobName, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("jobName", jobName);
        return this.isExist("isExistJobName", params);
    }

    @Override
    public boolean isExisPostJobCode(String jobCode, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("jobCode", jobCode);
        return this.isExist("isExistJobCode", params);
    }

    @Override
    public boolean isExistChildByParentCode(String parentCode, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("parentCode", parentCode);
        return this.isExist("isExistChildByParentCode", params);
    }

    @Override
    public PostJob getPostJobByCode(String jobCode, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("jobCode", jobCode);
        return (PostJob)((Object)this.getUnique("select", params));
    }

    @Override
    public List<PostJob> getPostJobListByTenantId(String tenantId) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("tenantId", tenantId);
        return this.getList("select", dic);
    }

    @Override
    public String getJsonNodes(String tenantId, boolean isNeedRoot) {
        List<PostJob> data = this.getPostJobListByTenantId(tenantId);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        if (isNeedRoot) {
            TreeNode node = new TreeNode();
            node.setId("root");
            node.setPid("");
            node.setAttributes(StringUtil.format((String)"{groupCode:'{0}',groupId:'{1}',groupName:'{2}',parentId:'{3}',groupType:'{4}'}", (Object[])new Object[]{"Root", "Root", "\u7cfb\u7edf", "", ""}));
            node.setText("\u7cfb\u7edf\u6839\u7ed3\u70b9");
            list.add(node);
        }
        for (PostJob d : data) {
            TreeNode node = new TreeNode();
            node.setId(d.getJobCode());
            node.setPid(d.getParentCode());
            node.setText(d.getJobName());
            node.setAttributes(StringUtil.format((String)"{groupCode:'{0}',groupId:'{1}',groupName:'{2}',parentId:'{3}',groupType:'{4}'}", (Object[])new Object[]{d.getJobCode(), d.getId(), d.getJobName(), d.getParentCode(), ""}));
            list.add(node);
        }
        TreeNodeHelper treeNodeHelper = new TreeNodeHelper();
        String jsonTree = treeNodeHelper.generateTreeRoot(list).toJsonTreeString();
        return JsonHelper.outDataArrResult((boolean)true, (String)"", (String)jsonTree, (CodeEnum)CodeEnum.success);
    }

    public List<PostJob> getListByPage(String whereStr, String strOrderBy, int pageIndex, int pageSize, MyInteger recordCount, MyInteger pagesCount, Integer doCount) {
        return MapperDbHelper.getListByProPageQuery((String)"sys_postjob", (String)"*", (String)"", (String)strOrderBy, (String)whereStr, (int)pageIndex, (int)pageSize, (MyInteger)recordCount, (MyInteger)pagesCount, (int)doCount, PostJob.class);
    }

    public String getNamespace() {
        return PostJob.class.getName();
    }
}

