/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.system.admin.impl.services;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.f2bpm.base.core.app.AppConfig;
import com.f2bpm.base.core.entity.MyInteger;
import com.f2bpm.base.core.entity.TreeNode;
import com.f2bpm.base.core.enums.CodeEnum;
import com.f2bpm.base.core.enums.DalType;
import com.f2bpm.base.core.utils.CollectionUtil;
import com.f2bpm.base.core.utils.JsonHelper;
import com.f2bpm.base.core.utils.TreeNodeHelper;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.orm.mapper.MapperDbHelper;
import com.f2bpm.orm.mapper.MyBatisImpl;
import com.f2bpm.system.admin.impl.api.IResourceService;
import com.f2bpm.system.admin.impl.model.Resource;
import com.f2bpm.system.admin.login.AuthenticateHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="resourceService")
public class ResourceService
extends MyBatisImpl<String, Resource>
implements IResourceService {
    String dbType = AppConfig.getDbType();

    public String getNamespace() {
        return Resource.class.getName();
    }

    @Override
    public boolean isExistResourceId(String resourceId, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resourceId", resourceId);
        params.put("tenantId", tenantId);
        boolean exist = this.isExist("isexistResourceId", params);
        return exist;
    }

    @Override
    public List<Resource> getListByUserId(String tenantId, String userId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("UserId", userId);
        params.put("TenantId", tenantId);
        return this.getList("sys_Resource_SelectByUserId", params);
    }

    @Override
    public List<Resource> getEnabledListByUserId(String tenantId, String userId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("UserId", userId);
        params.put("TenantId", tenantId);
        params.put("Enabled", 1);
        return this.getList("sys_Resource_SelectByUserId", params);
    }

    @Override
    public Resource getModelByResourceId(String tenantId, String resourceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ResourceId", resourceId);
        params.put("TenantId", tenantId);
        return (Resource)((Object)this.getUnique("select", params));
    }

    @Override
    public List<Resource> getListByInResourceIds(String resourceIds) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InResourceIds", CollectionUtil.stringsToSinglequoteString((String)resourceIds));
        return this.getList("select", params);
    }

    @Override
    public List<Resource> getListByInIds(String ids) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InIds", CollectionUtil.stringsToSinglequoteString((String)ids));
        return this.getList("select", params);
    }

    @Override
    public List<Resource> getListByRoleId(String roleId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("RoleId", roleId);
        return this.getList("sys_Resource_SelectByRole", params);
    }

    @Override
    public List<Resource> getListByTenantId(String tenantId, int enabled, int isTenantMust) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("TenantId", tenantId);
        if (enabled != -1) {
            params.put("Enabled", enabled);
        }
        if (isTenantMust != -1) {
            params.put("IsTenantMust", isTenantMust);
        }
        return this.getList("select", params);
    }

    @Override
    public List<Resource> getListByInRoleIds(String tenantId, String inRoleIds) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InRoleId", CollectionUtil.stringsToSinglequoteString((String)inRoleIds));
        params.put("TenantId", tenantId);
        return this.getList("sys_Resource_SelectByRole", params);
    }

    @Override
    public boolean deleteByTenantId(String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TenantId", tenantId);
        return this.deleteByKey("deleteByTenantId", params) > 0;
    }

    @Override
    public String getUserResouceNamesTxt(String tenantId, String userId) {
        return this.getUserResouceNames(this.getListByUserId(tenantId, userId));
    }

    @Override
    public String getUserResouceNames(List<Resource> list) {
        StringBuilder functions = new StringBuilder();
        for (Resource r : list) {
            functions.append("\u3010");
            functions.append(r.getName());
            functions.append("\u3011");
        }
        return functions.toString();
    }

    @Override
    public int deleteAndSubs(String resourceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ParentId", resourceId);
        int n = -1;
        if (this.dbType.equals(DalType.mysql.toString())) {
            List allOrgList = this.getAll();
            ArrayList listResult = new ArrayList();
            CollectionUtil.getChildList((List)allOrgList, (String)resourceId, (boolean)true, (String)"resourceId", (String)"parentId", listResult);
            List listOrgIds = CollectionUtil.listT2ListString(listResult, (String)"resourceId");
            n = this.deleteByList(listOrgIds);
        } else {
            n = this.deleteByKey(this.dbType + "_sys_Resource_DeleteResourceAndAllSubResource", params);
        }
        return n;
    }

    @Override
    public int deleteByListAndSubs(String listStringID) {
        String[] arr = listStringID.split(",");
        int n = 0;
        for (String resid : arr) {
            n += this.deleteAndSubs(resid);
        }
        return n;
    }

    @Override
    public int deleteByListAndSubs(List<String> listStringID) {
        int n = 0;
        for (String resId : listStringID) {
            n += this.deleteAndSubs(resId);
        }
        return n;
    }

    @Override
    public List<Resource> getListByTenantIdParentId(String tenantId, String parentId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ParentId", parentId);
        params.put("TenantId", tenantId);
        params.put("Enabled", 1);
        return this.getList("select", params);
    }

    @Override
    public List<Resource> getListByTypeParentId(String type, String parentId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Type", type);
        params.put("ParentId", parentId);
        params.put("Enabled", 1);
        return this.getList("select", params);
    }

    @Override
    public int updateIsActive(String resourceId, boolean isActive) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ResourceId", resourceId);
        params.put("Enabled", isActive ? "1" : "0");
        int n = -1;
        n = this.updateByKey("sys_Resource_UpdateIsActive", params);
        return n;
    }

    @Override
    public List<Resource> getListByType(String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Type", type);
        params.put("Enabled", 1);
        return this.getList("select", params);
    }

    @Override
    public List<Resource> getListByNotInResourceIds(String tenantId, String notInResourceIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("TenantId", tenantId);
        params.put("Enabled", 1);
        params.put("NotInResourceIds", CollectionUtil.stringsToSinglequoteString((String)notInResourceIds));
        return this.getList("select", params);
    }

    @Override
    public String getRootMenus(int topN, StringBuilder defaultRootMenuId) {
        StringBuilder menusStr = new StringBuilder();
        String htmTemplate = "<li><a onclick=\"showChildrenMenu('{0}')\" href=\"javascript:void(0)\" ><i   class=\"fa {1} bigger-20 rootImg\"></i><h2>{2}</h2></a></li>";
        List<Resource> listLevel1 = this.getListByTypeParentId("menu", "Root");
        menusStr.append("<ul class=\"nav\">");
        int count = listLevel1.size();
        if (count > topN) {
            count = topN;
        }
        for (int i = 0; i < count; ++i) {
            Resource r = listLevel1.get(i);
            if (i == 0) {
                defaultRootMenuId.append(r.getResourceId());
            }
            menusStr.append(StringUtil.format((String)htmTemplate, (Object[])new Object[]{r.getResourceId(), r.getMenuImg(), r.getName()}));
        }
        menusStr.append("</ul>");
        return menusStr.toString();
    }

    @Override
    public String getCurrentUserSystemMenuJson(String parentId, String tenantId, String userId, boolean isAdmin, boolean isOnlyFirstLevel) {
        return this.getCurrentUserSystemMenuJson(parentId, tenantId, userId, isAdmin, isOnlyFirstLevel, null);
    }

    @Override
    public String getCurrentUserSystemMenuJson(String parentId, String tenantId, String userId, boolean isAdmin, boolean isOnlyFirstLevel, StringBuilder returnResourceList) {
        String[] excludesProperty = new String[]{"remarks", "selectAction", "createdTime", "creator", "controller", "ext_Str3", "ext_Str4", "ext_Str5", "oleResourceId", "updatetor", "updateTime"};
        ArrayList<Resource> listMenu = new ArrayList<Resource>();
        ArrayList<Resource> listLevel1 = new ArrayList<Resource>();
        ArrayList listLevel2 = new ArrayList();
        ArrayList listLevel3 = new ArrayList();
        List<Resource> listResourceAll = null;
        listResourceAll = isAdmin ? AuthenticateHelper.getUserResourceListByTenantId(tenantId, userId) : AuthenticateHelper.getUserEnabledResourceListByUserId(tenantId, userId);
        JSONArray jsonArray = new JSONArray();
        if (CollectionUtil.isNotNullOrWhiteSpace(listResourceAll)) {
            for (Resource r : listResourceAll) {
                if (r.getEnabled() && returnResourceList != null) {
                    JSONObject jObject = new JSONObject();
                    jObject.put("resourceId", (Object)r.getResourceId());
                    jObject.put("alias", (Object)r.getAlias());
                    jObject.put("title", (Object)r.getName());
                    jObject.put("url", (Object)r.getFunctionUrl());
                    jsonArray.add((Object)jObject);
                }
                if (!r.getEnabled() || !r.getParentId().equalsIgnoreCase(parentId)) continue;
                listMenu.add(r);
                listLevel1.add(r);
            }
            if (returnResourceList != null) {
                returnResourceList.append(jsonArray.toString());
            }
            if (!isOnlyFirstLevel) {
                for (Resource r : listLevel1) {
                    CollectionUtil.getChildList(listResourceAll, (String)r.getResourceId(), (String)"resourceId", (String)"parentId", listMenu);
                }
            }
        }
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        for (Resource d : listMenu) {
            TreeNode node = new TreeNode();
            node.setId(d.getResourceId());
            node.setPid(d.getParentId());
            node.setText(d.getName());
            String jsonAttr = JsonHelper.objectToJSON((Object)((Object)d), (String[])excludesProperty);
            node.setAttributes(jsonAttr);
            list.add(node);
        }
        TreeNodeHelper treeNodeHelper = new TreeNodeHelper();
        String jsonTree = "";
        jsonTree = treeNodeHelper.generateTreeRoot(list).toJsonTreeString(true);
        return jsonTree;
    }

    public List<Resource> getListByPage(String whereStr, String strOrderBy, int pageIndex, int pageSize, MyInteger recordCount, MyInteger pagesCount, Integer doCount) {
        return MapperDbHelper.getListEntityByProPageQuery((String)"sys_Resource", (String)"*", (String)strOrderBy, (String)whereStr, (int)pageIndex, (int)pageSize, (MyInteger)recordCount, (MyInteger)pagesCount, (int)doCount, Resource.class);
    }

    @Override
    public String getJsonNodes(String tenantId, boolean isDefaultColsed) {
        TreeNode node;
        List<Resource> data = this.getListByTenantId(tenantId, -1, -1);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        for (Resource d : data) {
            node = new TreeNode();
            node.setId(d.getResourceId());
            node.setPid(d.getParentId());
            node.setState(isDefaultColsed ? "closed" : "open");
            node.setText(d.getName());
            node.setOrderNo(d.getOrderNum());
            list.add(node);
        }
        node = new TreeNode();
        node.setId("Root");
        node.setPid("");
        node.setText("\u7cfb\u7edf\u6839\u7ed3\u70b9");
        node.setOrderNo(0);
        list.add(node);
        TreeNodeHelper treeNodeHelper = new TreeNodeHelper();
        String jsonTree = "";
        jsonTree = isDefaultColsed ? treeNodeHelper.generateTreeRoot(list).toJsonTreeString() : treeNodeHelper.generateTreeRoot(list).toJsonTreeString();
        return JsonHelper.outDataArrResult((boolean)true, (String)"", (String)jsonTree, (CodeEnum)CodeEnum.success);
    }

    @Override
    public String getJsonNodesAndCheckedTargetResource(String tenantId, List<String> listCheckedResource) {
        List<Resource> data = this.getListByTenantId(tenantId, -1, -1);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        TreeNode node = new TreeNode();
        node.setId("Root");
        node.setPid("");
        node.setText("\u7cfb\u7edf\u6839\u7ed3\u70b9");
        list.add(node);
        for (Resource d : data) {
            boolean ischeck;
            node = new TreeNode();
            node.setId(d.getResourceId().toString());
            node.setPid(d.getParentId().toString());
            node.setText(d.getName());
            if (CollectionUtil.isNotNullOrWhiteSpace(listCheckedResource) && (ischeck = listCheckedResource.contains(d.getResourceId()))) {
                node.setChecked("true");
            }
            list.add(node);
        }
        TreeNodeHelper treeNodeHelper = new TreeNodeHelper();
        String jsonTree = treeNodeHelper.generateTreeRoot(list).toJsonTreeString();
        return JsonHelper.outDataArrResult((boolean)true, (String)"", (String)jsonTree, (CodeEnum)CodeEnum.success);
    }
}

