/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.system.admin.impl.services;

import com.f2bpm.base.core.entity.MyInteger;
import com.f2bpm.base.core.utils.CollectionUtil;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.orm.mapper.MapperDbHelper;
import com.f2bpm.orm.mapper.MyBatisImpl;
import com.f2bpm.system.admin.impl.api.IRoleInResourceService;
import com.f2bpm.system.admin.impl.model.RoleInResource;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="roleInResourceService")
public class RoleInResourceService
extends MyBatisImpl<String, RoleInResource>
implements IRoleInResourceService {
    @Override
    public int delete(String roleId, String resourceId, String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("RoleId", roleId);
        ht.put("ResourceId", resourceId);
        ht.put("TenantId", tenantId);
        int n = -1;
        n = this.deleteByKey("sys_RoleInResource_DeleteByRoleIdResourceId", ht);
        return n;
    }

    @Override
    public int deleteByRoleIdList(String listStringID, String tenantId) {
        int n = -1;
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("listStringID", CollectionUtil.stringsToSinglequoteString((String)listStringID));
        ht.put("TenantId", tenantId);
        n = this.deleteByKey("sys_RoleInResource_DeleteByRoleIdList", ht);
        return n;
    }

    @Override
    public boolean deleteByTenantId(String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TenantId", tenantId);
        return this.deleteByKey("deleteByTenantId", params) > 0;
    }

    @Override
    public int deleteByList(List<String> listStringID, String tenantId) {
        int n = -1;
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("listStringID", CollectionUtil.list2StringAndSinglequote(listStringID));
        ht.put("TenantId", tenantId);
        n = this.deleteByKey("sys_RoleInResource_DeleteByRoleIdList", ht);
        return n;
    }

    @Override
    public RoleInResource getModelByRoleIdResourceId(String roleId, String resourceId, String tenantId) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("RoleId", roleId);
        dic.put("ResourceId", resourceId);
        dic.put("TenantId", tenantId);
        HashMap ht = new HashMap();
        return (RoleInResource)((Object)this.getUnique("select", ht));
    }

    @Override
    public List<RoleInResource> getListByRoleId(String roleId, String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("RoleId", roleId);
        ht.put("TenantId", tenantId);
        return this.getList("select", ht);
    }

    @Override
    public List<RoleInResource> getListByInRoleIds(String roleIds, String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("InRoleId", CollectionUtil.stringsToSinglequoteString((String)roleIds));
        ht.put("TenantId", tenantId);
        return this.getList("select", ht);
    }

    @Override
    public List<RoleInResource> getListByRoleIdRresType(String roleId, String rresType, String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("RoleId", roleId);
        ht.put("RresType", rresType);
        ht.put("TenantId", tenantId);
        return this.getList("select", ht);
    }

    @Override
    public String getRoleInResource(String roleId, String tenantId) {
        StringBuilder resources = new StringBuilder();
        List<RoleInResource> list = this.getListByRoleId(roleId, tenantId);
        for (RoleInResource rr : list) {
            resources.append(rr.getResourceId().trim());
            resources.append(",");
        }
        if (!resources.toString().trim().equals("")) {
            return StringUtil.trimEnd((String)resources.toString(), (String)",");
        }
        return "";
    }

    @Override
    public String getRoleInResourceByRresType(String roleId, String rresType, String tenantId) {
        StringBuilder resources = new StringBuilder();
        List<RoleInResource> list = this.getListByRoleIdRresType(roleId, rresType, tenantId);
        for (RoleInResource rr : list) {
            resources.append(rr.getResourceId().trim());
            resources.append(",");
        }
        if (!resources.toString().trim().equals("")) {
            return StringUtil.trimEnd((String)resources.toString(), (String)",");
        }
        return "";
    }

    public List<RoleInResource> getListByPage(String whereStr, String strOrderBy, int pageIndex, int pageSize, MyInteger recordCount, MyInteger pagesCount, Integer doCount) {
        String tableList = " sys_RoleInResource rres INNER JOIN sys_Roless r ON rres.RoleId = r.RoleId and rres.tenantId=r.tenantId INNER JOIN  sys_Resource res ON rres.ResourceId=res.ResourceId  and rres.tenantId=res.tenantId ";
        String fileds = " rres.*,r.RoleName,res.Name AS ResourceName   ";
        return MapperDbHelper.getListEntityByProPageQuery((String)tableList, (String)fileds, (String)strOrderBy, (String)whereStr, (int)pageIndex, (int)pageSize, (MyInteger)recordCount, (MyInteger)pagesCount, (int)doCount, RoleInResource.class);
    }

    public String getNamespace() {
        return RoleInResource.class.getName();
    }
}

