/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.system.admin.impl.services;

import com.f2bpm.base.core.entity.MyInteger;
import com.f2bpm.base.core.entity.TreeNode;
import com.f2bpm.base.core.enums.CodeEnum;
import com.f2bpm.base.core.utils.JsonHelper;
import com.f2bpm.base.core.utils.TreeNodeHelper;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.orm.mapper.MapperDbHelper;
import com.f2bpm.orm.mapper.MyBatisImpl;
import com.f2bpm.system.admin.impl.api.IRolesService;
import com.f2bpm.system.admin.impl.model.Roles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="rolesService")
public class RolesService
extends MyBatisImpl<String, Roles>
implements IRolesService {
    @Override
    public boolean isExistRoleCode(String tenantId, String roleCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TenantId", tenantId);
        params.put("RoleCode", roleCode);
        return this.isExist("isExistRoleCode", params);
    }

    @Override
    public boolean isExistRoleName(String tenantId, String roleName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TenantId", tenantId);
        params.put("RoleName", roleName);
        return this.isExist("isExistRoleName", params);
    }

    @Override
    public boolean isExistRoleId(String tenantId, String roleId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TenantId", tenantId);
        params.put("RoleId", roleId);
        return this.isExist("isExistRoleId", params);
    }

    @Override
    public int deleteByRoleId(String roleId, String tenantId) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("RoleId", roleId);
        dic.put("TenantId", tenantId);
        return this.deleteByKey("deleteByRoleId", dic);
    }

    @Override
    public int deleteUserInRolesByRoleId(String roleId, String tenantId) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("RoleId", roleId);
        dic.put("TenantId", tenantId);
        return this.deleteByKey("sys_UserInRole_DeleteByRoleId", dic);
    }

    @Override
    public boolean deleteByTenantId(String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TenantId", tenantId);
        return this.deleteByKey("deleteByTenantId", params) > 0;
    }

    @Override
    public int deleteRolesInResourcesByRoleID(String roleId, String tenantId) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("RoleId", roleId);
        dic.put("TenantId", tenantId);
        return this.deleteByKey("sys_RoleInResource_DeleteByRoleId", dic);
    }

    @Override
    public Roles getModelByRoleId(String roleId, String tenantId) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("RoleId", roleId);
        dic.put("TenantId", tenantId);
        return (Roles)((Object)this.getUnique("select", dic));
    }

    @Override
    public Roles getModelByTenantIdId(String roleId, String tenantId) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("RoleId", roleId);
        dic.put("TenantId", tenantId);
        return (Roles)((Object)this.getUnique("select", dic));
    }

    @Override
    public Roles getModelByRoleName(String tenantId, String roleName) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("RoleName", roleName);
        dic.put("TenantId", tenantId);
        return (Roles)((Object)this.getUnique("select", dic));
    }

    @Override
    public List<Roles> getModelRoleType(String tenantId, String roleType) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("RoleType", roleType);
        dic.put("TenantId", tenantId);
        return this.getList("select", dic);
    }

    @Override
    public List<Roles> getRolesByParentId(String parentId, String tenantId) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("ParentId", parentId);
        dic.put("TenantId", tenantId);
        return this.getList("select", dic);
    }

    @Override
    public List<Roles> getRolesByTenantId(String tenantId) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("TenantId", tenantId);
        return this.getList("select", dic);
    }

    @Override
    public List<Roles> getListByRoleType(String tenantId, String roleType) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("RoleType", roleType);
        ht.put("TenantId", tenantId);
        return this.getList("select", ht);
    }

    public List<Roles> getListByPage(String whereStr, String strOrderBy, int pageIndex, int pageSize, MyInteger recordCount, MyInteger pagesCount, Integer doCount) {
        return MapperDbHelper.getListEntityByProPageQuery((String)"sys_Roless", (String)"*", (String)strOrderBy, (String)whereStr, (int)pageIndex, (int)pageSize, (MyInteger)recordCount, (MyInteger)pagesCount, (int)doCount, Roles.class);
    }

    @Override
    public String getJsonNodes(String tenantId, boolean isNeedRoot) {
        return this.getJsonNodes(tenantId, "", isNeedRoot);
    }

    @Override
    public String getJsonNodes(String tenantId, String roleType, boolean isNeedRoot) {
        List<Roles> data = roleType == "" ? this.getRolesByTenantId(tenantId) : this.getListByRoleType(tenantId, roleType);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        if (isNeedRoot) {
            TreeNode node = new TreeNode();
            node.setId("Root");
            node.setPid("");
            node.setAttributes(StringUtil.format((String)"{groupCode:'{0}',groupId:'{1}',groupName:'{2}',parentId:'{3}',groupType:'{4}'}", (Object[])new Object[]{"Root", "Root", "\u7cfb\u7edf", "", ""}));
            node.setText("\u7cfb\u7edf\u6839\u7ed3\u70b9");
            list.add(node);
        }
        for (Roles d : data) {
            TreeNode node = new TreeNode();
            node.setId(d.getRoleId());
            node.setPid(d.getParentId());
            node.setText(d.getRoleName());
            node.setAttributes(StringUtil.format((String)"{groupCode:'{0}',groupId:'{1}',groupName:'{2}',parentId:'{3}',groupType:'{4}'}", (Object[])new Object[]{d.getRoleCode(), d.getRoleId(), d.getRoleName(), d.getParentId(), d.getRoleType()}));
            list.add(node);
        }
        TreeNodeHelper treeNodeHelper = new TreeNodeHelper();
        String jsonTree = treeNodeHelper.generateTreeRoot(list).toJsonTreeString();
        return JsonHelper.outDataArrResult((boolean)true, (String)"", (String)jsonTree, (CodeEnum)CodeEnum.success);
    }

    public String getNamespace() {
        return Roles.class.getName();
    }
}

