/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.system.admin.impl.services;

import com.f2bpm.base.core.entity.MyInteger;
import com.f2bpm.base.core.utils.CollectionUtil;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.base.core.utils.time.DateUtil;
import com.f2bpm.orm.mapper.MapperDbHelper;
import com.f2bpm.orm.mapper.MyBatisImpl;
import com.f2bpm.system.admin.impl.api.IUsersService;
import com.f2bpm.system.admin.impl.model.Users;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="usersService")
public class UsersService
extends MyBatisImpl<String, Users>
implements IUsersService {
    @Override
    public boolean isStatusEnableByUserId(String userId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("UserId", userId);
        return this.isExist("isStatusEnable", ht);
    }

    @Override
    public boolean isExistByUserName(String userName, String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("UserName", userName);
        ht.put("TenantId", tenantId);
        return this.isExist("isExistByUserName", ht);
    }

    @Override
    public boolean isStatusEnableByUserName(String userName, String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("UserName", userName);
        ht.put("TenantId", tenantId);
        return this.isExist("isStatusEnableByUserName", ht);
    }

    @Override
    public boolean isExistUser(String userName, String password, int status, String tenantId) {
        if (userName.equals("") || password.equals("")) {
            return false;
        }
        HashMap<String, Object> ht = new HashMap<String, Object>();
        ht.put("UserName", userName);
        ht.put("Password", password);
        ht.put("TenantId", tenantId);
        ht.put("Status", status);
        return this.isExist("isExistUser", ht);
    }

    @Override
    public boolean isExistUserByUserId(String userId, String password, int status) {
        if (userId.equals("") || password.equals("")) {
            return false;
        }
        HashMap<String, Object> ht = new HashMap<String, Object>();
        ht.put("UserId", userId);
        ht.put("Password", password);
        ht.put("Status", status);
        return this.isExist("isExistUserByUserId", ht);
    }

    @Override
    public boolean deleteByTenantId(String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TenantId", tenantId);
        return this.deleteByKey("deleteByTenantId", params) > 0;
    }

    @Override
    public int updateWeixinID(String userName, String weixinID, String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("WeixinID", weixinID);
        ht.put("UserName", userName);
        ht.put("TenantId", tenantId);
        return this.updateByKey("sys_Users_UpdateWeixinID", ht);
    }

    @Override
    public int updatePwd(String password, String userId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("Password", password);
        ht.put("UserId", userId);
        ht.put("LastModPwdTime", DateUtil.getCurrentDateStr());
        return this.updateByKey("sys_Users_UpdatePassword", ht);
    }

    @Override
    public void updateStatus(int status, String userId) {
        HashMap<String, Object> ht = new HashMap<String, Object>();
        ht.put("Status", status);
        ht.put("UserId", userId);
        this.updateByKey("sys_Users_UpdateStatus", ht);
    }

    @Override
    public void updateLoginTimes(String userId, String lastLoginIP) {
        HashMap<String, Object> ht = new HashMap<String, Object>();
        ht.put("LastLoginIP", lastLoginIP);
        ht.put("UserId", userId);
        ht.put("LastLoginTime", DateUtil.getCurrentDate());
        this.updateByKey("sys_Users_UpdateLoginTimes", ht);
    }

    @Override
    public Users getUserByWeixinID(String weixinID, String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("WeixinId", weixinID);
        ht.put("TenantId", tenantId);
        return (Users)((Object)this.getUnique("select", ht));
    }

    @Override
    public Users getUserByWeixinID(String weixinID) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("WeixinId", weixinID);
        return (Users)((Object)this.getUnique("select", ht));
    }

    @Override
    public List<Users> getAllEnableList(String tenantId) {
        HashMap<String, Object> ht = new HashMap<String, Object>();
        ht.put("Status", 1);
        ht.put("TenantId", tenantId);
        return this.getList("select", ht);
    }

    @Override
    public List<Users> getUserListByRoleId(String roleId, String tenantId) {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("RoleId", roleId);
        dic.put("TenantId", tenantId);
        return this.getList("user_UserRole_Select", dic);
    }

    @Override
    public Users getUserByUserId(String userId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("UserId", userId);
        return (Users)((Object)this.getUnique("select", ht));
    }

    @Override
    public Users getUserMasterOrgByUserId(String userId) {
        HashMap<String, Object> ht = new HashMap<String, Object>();
        ht.put("UserId", userId);
        ht.put("IsMaster", 1);
        return (Users)((Object)this.getUnique("user_UsersOrg_Select", ht));
    }

    @Override
    public Users getUserMasterOrgByUserName(String userName, String tenantId) {
        HashMap<String, Object> ht = new HashMap<String, Object>();
        ht.put("UserName", userName);
        ht.put("TenantId", tenantId);
        ht.put("IsMaster", 1);
        return (Users)((Object)this.getUnique("user_UsersOrg_Select", ht));
    }

    @Override
    public Users getUserByUserName(String userName, String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("UserName", userName);
        ht.put("TenantId", tenantId);
        return (Users)((Object)this.getUnique("select", ht));
    }

    @Override
    public Users getUserByEmployeeId(String employeeId, String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("EmployeeId", employeeId);
        ht.put("TenantId", tenantId);
        return (Users)((Object)this.getUnique("select", ht));
    }

    @Override
    public boolean isExistUserByEmployeeId(String employeeId, String tenantId) {
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("EmployeeId", employeeId);
        ht.put("TenantId", tenantId);
        return this.isExist("isExistUserByEmployeeId", ht);
    }

    @Override
    public List<String> getListRoleNamesByUserId(String userId) {
        return CollectionUtil.listMap2IList(this.getRolesListByUserId(userId), (String)"RoleName");
    }

    @Override
    public List<Map<String, String>> getRolesListByUserId(String userId) {
        String sql = StringUtil.format((String)"select r.RoleName, u.RealName,u.UserName,r.RoleType,ur.* from  sys_Users u INNER JOIN  sys_UserInRole ur ON u.UserId=ur.UserId  and u.tenantId=ur.tenantId  INNER JOIN  sys_Roless r  ON ur.RoleId =r.RoleId and ur.tenantId =r.tenantId where u.UserId ='{0}'", (Object[])new Object[]{userId});
        List list = MapperDbHelper.getListMapBySql((String)sql);
        return list;
    }

    public List<Users> getListByPage(String whereStr, String strOrderBy, int pageIndex, int pageSize, MyInteger recordCount, MyInteger pagesCount, Integer doCount) {
        return MapperDbHelper.getListEntityByProPageQuery((String)"  sys_Users u  inner join sys_userinorg ur on u.UserId=ur.UserId inner join sys_Organizations d on ur.OrgId=d.OrgId ", (String)"  u.*,d.orgName,d.orgFullName,d.orgLevel ", (String)strOrderBy, (String)whereStr, (int)pageIndex, (int)pageSize, (MyInteger)recordCount, (MyInteger)pagesCount, (int)doCount, Users.class);
    }

    @Override
    public List<Users> getOnlyUserListByPage(String whereStr, String strOrderBy, int pageIndex, int pageSize, MyInteger recordCount, MyInteger pagesCount, Integer doCount) {
        return MapperDbHelper.getListEntityByProPageQuery((String)"  sys_Users ", (String)" * ", (String)strOrderBy, (String)whereStr, (int)pageIndex, (int)pageSize, (MyInteger)recordCount, (MyInteger)pagesCount, (int)doCount, Users.class);
    }

    public String getNamespace() {
        return Users.class.getName();
    }
}

