/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.system.admin.login;

import com.f2bpm.base.core.app.AppConfig;
import com.f2bpm.base.core.cache.CacheManagePool;
import com.f2bpm.base.core.cache.MemoryCache;
import com.f2bpm.base.core.crypto.EncryptUtil;
import com.f2bpm.base.core.utils.AppUtil;
import com.f2bpm.base.core.utils.CollectionUtil;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.base.core.utils.time.DateUtil;
import com.f2bpm.process.engine.utils.AuthorValidity;
import com.f2bpm.process.org.api.enums.GroupType;
import com.f2bpm.process.org.api.integrate.imodel.IUser;
import com.f2bpm.process.org.api.integrate.iservice.IUserGroupService;
import com.f2bpm.process.org.api.integrate.iservice.IUserService;
import com.f2bpm.system.admin.entity.LoginUser;
import com.f2bpm.system.admin.impl.api.IResourceService;
import com.f2bpm.system.admin.impl.api.IRolesService;
import com.f2bpm.system.admin.impl.api.IUserInRoleService;
import com.f2bpm.system.admin.impl.api.IUsersService;
import com.f2bpm.system.admin.impl.model.Resource;
import com.f2bpm.system.admin.impl.model.Roles;
import com.f2bpm.system.security.utils.LogUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AuthenticateHelper {
    private static MemoryCache cache = CacheManagePool.getInstance((String)"UserAuthenticateCacheManager");
    public static final String CacheManagerLongTime = "Long Time Cache Manager";
    public static final String CacheManagerLoginUser = "Login User Cache Manager";
    public static String UserCookieKey = AppConfig.getApp((String)"f2bpm.authorUserCookieKey", (String)"1C6D71CE-DA50-5d9a-8F09-218B001AC176").toLowerCase();
    public static int UserCookieExpire = Integer.parseInt(AppConfig.getApp((String)"f2bpm.authorUserCookieExpireSecond", (String)"-1"));
    public static final String AnonymousName = "anonymous";
    public static final String AnonymousRealName = "\u7cfb\u7edf\u533f\u540d\u7528\u6237";
    private static IUsersService usersService;
    private static IRolesService rolesService;
    private static IUserInRoleService userInRoleService;
    private static IUserService orgImplUserService;
    private static IUserGroupService orgImplUserGroupService;
    private static IResourceService resourcesService;

    public static IUserService getOrgImplUserService() {
        return orgImplUserService != null ? orgImplUserService : (orgImplUserService = (IUserService)AppUtil.getBean(IUserService.class));
    }

    public static IUserGroupService getOrgImplUserGroupService() {
        return orgImplUserGroupService != null ? orgImplUserGroupService : (orgImplUserGroupService = (IUserGroupService)AppUtil.getBean(IUserGroupService.class));
    }

    public static IUsersService getUsersService() {
        return usersService != null ? usersService : (usersService = (IUsersService)AppUtil.getBean(IUsersService.class));
    }

    public static IRolesService getRolesService() {
        return rolesService != null ? rolesService : (rolesService = (IRolesService)AppUtil.getBean(IRolesService.class));
    }

    public static IUserInRoleService getUserInRoleService() {
        return userInRoleService != null ? userInRoleService : (userInRoleService = (IUserInRoleService)AppUtil.getBean(IUserInRoleService.class));
    }

    public static IResourceService getResourcesService() {
        return resourcesService != null ? resourcesService : (resourcesService = (IResourceService)AppUtil.getBean(IResourceService.class));
    }

    public static List<Resource> getOrgEngineImplResourceList(String tenantId, String userId) {
        IUser iuser = AuthenticateHelper.getOrgImplUserService().getUserById(userId);
        List<Resource> listResources = null;
        boolean isAdmin = orgImplUserService.isAdminUserByAccount(iuser.getAccount());
        IUserGroupService userGroupService = AuthenticateHelper.getOrgImplUserGroupService();
        if (!isAdmin) {
            List listGroup = userGroupService.getGroupListByUserId(iuser.getUserId(), GroupType.role.toString());
            if (CollectionUtil.isNotNullOrWhiteSpace((Collection)listGroup)) {
                List listStrings = CollectionUtil.listT2ListString((List)listGroup, (String)"roleId");
                listResources = AuthenticateHelper.getUserResourceListByInRoleIds(tenantId, CollectionUtil.list2String((List)listStrings));
            }
        } else {
            String unMenus = AppConfig.getApp((String)"unavailableMenus");
            listResources = AuthenticateHelper.getResourcesService().getListByNotInResourceIds(iuser.getTenantId(), unMenus);
        }
        return listResources;
    }

    public static Map<String, String> getUserResources(List<Resource> resourcesList) {
        if (CollectionUtil.isNullOrWhiteSpace(resourcesList)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> resourceDict = new HashMap<String, String>();
        for (Resource r : resourcesList) {
            resourceDict.put(r.getResourceId(), r.getName());
        }
        return resourceDict;
    }

    public static List<Resource> getUserResourceListByUserId(String tenantId, String userId) {
        boolean isOrgEngineSimulatedLogin = AppConfig.getBoolApp((String)"isOrgEngineSimulatedLogin");
        if (isOrgEngineSimulatedLogin) {
            return AuthenticateHelper.getOrgEngineImplResourceList(tenantId, userId);
        }
        return AuthenticateHelper.getResourcesService().getListByUserId(tenantId, userId);
    }

    public static List<Resource> getUserEnabledResourceListByUserId(String tenantId, String userId) {
        boolean isOrgEngineSimulatedLogin = AppConfig.getBoolApp((String)"isOrgEngineSimulatedLogin");
        if (isOrgEngineSimulatedLogin) {
            return AuthenticateHelper.getOrgEngineImplResourceList(tenantId, userId);
        }
        return AuthenticateHelper.getResourcesService().getEnabledListByUserId(tenantId, userId);
    }

    public static List<Resource> getUserResourceListByTenantId(String tenantId, String userId) {
        boolean isOrgEngineSimulatedLogin = AppConfig.getBoolApp((String)"isOrgEngineSimulatedLogin");
        if (isOrgEngineSimulatedLogin) {
            return AuthenticateHelper.getOrgEngineImplResourceList(tenantId, userId);
        }
        return AuthenticateHelper.getResourcesService().getListByTenantId(tenantId, 1, -1);
    }

    public static List<Resource> getUserResourceListByRoleId(String roleId) {
        return AuthenticateHelper.getResourcesService().getListByRoleId(roleId);
    }

    public static List<Resource> getUserResourceListByInRoleIds(String tenantId, String inRoleIds) {
        return AuthenticateHelper.getResourcesService().getListByInRoleIds(tenantId, inRoleIds);
    }

    public static List<String> getListRoleNamesByUserId(String userId) {
        return AuthenticateHelper.getUsersService().getListRoleNamesByUserId(userId);
    }

    public static List<Roles> getListRoleByUserId(String userId, String tenantId) {
        return AuthenticateHelper.getUserInRoleService().getRoleListByUserId(userId, tenantId);
    }

    public static List<Resource> getAllListResource() {
        return AuthenticateHelper.getResourcesService().getAll();
    }

    public static boolean ContainsCache(String userName) {
        return cache.containKey(userName);
    }

    public static void InsertCache(String userName, LoginUser user) {
        if (!cache.containKey(userName)) {
            cache.add(userName, (Object)user);
        }
    }

    public static String getEncryptPassword(String password, String userId) throws Exception {
        String encryptPassword = EncryptUtil.encryptMd5ByFactor((String)password, (String)userId);
        return encryptPassword;
    }

    public static void setUserCache(IUser user) {
        String key = StringUtil.format((String)"UserCache_{0}", (Object[])new Object[]{DateUtil.getCurrentDateStr(), user.getUserId()});
        AuthenticateHelper.removeUserCache(user.getUserId());
        cache.add(key, (Object)user);
    }

    public static void removeUserCache(String userId) {
        String key = StringUtil.format((String)"UserCache_{0}", (Object[])new Object[]{DateUtil.getCurrentDateStr(), userId});
        if (cache.containKey(key)) {
            cache.remove(key);
        }
    }

    public static IUser getUserCache(String token, IUser user) {
        String key = StringUtil.format((String)"UserCache_{0}", (Object[])new Object[]{DateUtil.getCurrentDateStr(), user.getUserId()});
        IUser iUser = null;
        if (!cache.containKey(key)) {
            iUser = (IUser)cache.getByKey(key);
        }
        return iUser;
    }

    public static String getParticular() {
        String vmsg = AuthorValidity.getAuthorValidaity();
        if (StringUtil.isNotEmpty((String)vmsg)) {
            return vmsg;
        }
        return "";
    }

    public static void clearExpiredUserCache() {
        try {
            String todyKey = StringUtil.format((String)"UserCache_{0}", (Object[])new Object[]{DateUtil.getCurrentDateStr()});
            Set set = cache.getAllKeys();
            for (String key : set) {
                boolean isExpire;
                if (!StringUtil.startsWithIgnoreCase((String)key, (String)"UserCache") || !(isExpire = !StringUtil.startsWithIgnoreCase((String)key, (String)todyKey))) continue;
                cache.remove(key);
            }
        }
        catch (Exception e) {
            LogUtil.writeLog((String)("\u6e05\u9664UserCache\u5f02\u5e38\uff1a" + e.toString()), AuthenticateHelper.class);
        }
    }
}

