/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.system.admin.login;

import com.f2bpm.base.core.app.AppConfig;
import com.f2bpm.base.core.crypto.EncryptUtil;
import com.f2bpm.base.core.delegate.Delegator;
import com.f2bpm.base.core.utils.AppUtil;
import com.f2bpm.base.core.utils.CollectionUtil;
import com.f2bpm.base.core.utils.DebugUtil;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.base.core.utils.time.DateUtil;
import com.f2bpm.base.core.web.RequestContext;
import com.f2bpm.process.org.api.integrate.imodel.IUser;
import com.f2bpm.process.org.api.integrate.iservice.IUserService;
import com.f2bpm.system.admin.cache.AdminCacheService;
import com.f2bpm.system.admin.entity.LoginUser;
import com.f2bpm.system.admin.impl.api.IRolesService;
import com.f2bpm.system.admin.impl.api.IUsersService;
import com.f2bpm.system.admin.impl.model.Resource;
import com.f2bpm.system.admin.impl.model.Users;
import com.f2bpm.system.admin.login.AuthenticateHelper;
import com.f2bpm.system.admin.login.LoginEventArgs;
import com.f2bpm.system.admin.login.LoginStatus;
import com.f2bpm.system.security.impl.iservices.ITenantorService;
import com.f2bpm.system.security.impl.model.Tenantor;
import com.f2bpm.system.security.oauthor.LoginUserCacheHelper;
import com.f2bpm.system.security.utils.TenantUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginService {
    static String nopassword = "af446d70-e2c1-11eb-a2a0-0242ac110002";
    public static LoginService Default = new LoginService();
    IUsersService usersService;
    IRolesService rolesService;
    private String _userName;
    private LoginUser _user;
    private Delegator loginSuccessEvent;
    private Delegator loginFailureEvent;

    public void setUsersService(IUsersService value) {
        this.usersService = value;
    }

    public void setRolesService(IRolesService value) {
        this.rolesService = value;
    }

    public String getUserName() {
        return this._userName;
    }

    public LoginUser getUser() {
        return this._user;
    }

    public LoginService() {
        this.usersService = AuthenticateHelper.getUsersService();
        this.rolesService = AuthenticateHelper.getRolesService();
    }

    public LoginService(IUsersService userService, IRolesService roleService) {
        this.usersService = userService;
        this.rolesService = roleService;
    }

    public LoginStatus login(String tenantId, String userName, String password, Map<String, Object> returnMap, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String vmsg;
        if (StringUtil.isNullOrEmpty((String)userName)) {
            throw new IllegalArgumentException("\u767b\u5f55\u7528\u6237\u540d(userName)\u4e3a\u7a7a.");
        }
        if (StringUtil.isNotEmpty((String)tenantId) && !tenantId.equalsIgnoreCase("BPM")) {
            ITenantorService tenantorService = (ITenantorService)AppUtil.getBean(ITenantorService.class);
            Tenantor tenantor = tenantorService.getModeByTenantCode(tenantId);
            if (tenantor == null || !tenantor.getIsEnabled()) {
                return LoginStatus.TenantNotFound;
            }
            if (DateUtil.compare((Date)tenantor.getEndTime(), (Date)DateUtil.getCurrentDate())) {
                return LoginStatus.TenantExpired;
            }
        }
        if (StringUtil.isNotEmpty((String)(vmsg = AuthenticateHelper.getParticular()))) {
            return LoginStatus.Expired;
        }
        this._userName = userName.trim();
        if (this.usersService == null) {
            this.usersService = AuthenticateHelper.getUsersService();
        }
        if (this.usersService == null) {
            return LoginStatus.Unknown;
        }
        LoginStatus status = LoginStatus.Unknown;
        Users user = null;
        user = this.usersService.getUserMasterOrgByUserName(userName, tenantId);
        if (DebugUtil.isDebug) {
            DebugUtil.addHereCostTime((String)"getUserMasterOrgByUserName", (HttpServletRequest)request);
        }
        if (user == null) {
            status = LoginStatus.AccountNotFound;
        } else if (user.getStatus() == 0) {
            status = LoginStatus.AccountDisabled;
        } else if (DateUtil.compare((Date)user.getEndTime(), (Date)DateUtil.getCurrentDate())) {
            status = LoginStatus.AccountExpired;
        } else if (user.getStatus() == 99) {
            status = LoginStatus.AccountDeleted;
        } else {
            status = LoginStatus.Success;
            String decryptedPassword = EncryptUtil.encryptMd5ByFactor((String)password, (String)user.getUserId());
            if (!user.getPassword().toLowerCase().equals(decryptedPassword.toLowerCase())) {
                status = LoginStatus.InvalidPassword;
            }
        }
        if (status.equals((Object)LoginStatus.Success)) {
            this._user = new LoginUser(user);
            if (AdminCacheService.getGlobalCache() == null) {
                AdminCacheService.setGlobalCache();
            }
            LoginUserCacheHelper.setUserCache((IUser)user);
            String clientId = request.getRemoteAddr();
            returnMap.put("userId", this._user.getUserId());
            returnMap.put("realName", this._user.getRealName());
            returnMap.put("orgId", this._user.getOrgId());
            returnMap.put("orgName", this._user.getOrgName());
            this.onLoginSuccess(new LoginEventArgs(status, "webform", tenantId, this._user.getUserId(), this._userName, this._user.getRealName(), request, response));
        } else {
            this.onLoginFailure(new LoginEventArgs(status, "webform", tenantId, null, this._userName, this._userName, request, response));
        }
        if (DebugUtil.isDebug) {
            DebugUtil.addHereCostTime((String)"login validate end", (HttpServletRequest)RequestContext.getHttpServletRequest());
        }
        return status;
    }

    public LoginStatus orgEngineSimulatedLoginByUserId(String tenantId, String userId, String loginOrgId, Map<String, Object> returnMap, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.orgEngineSimulatedLogin(tenantId, userId, "", nopassword, loginOrgId, returnMap, request, response);
    }

    public LoginStatus orgEngineSimulatedLoginByAccount(String tenantId, String account, String password, String loginOrgId, Map<String, Object> returnMap, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.orgEngineSimulatedLogin(tenantId, "", account, password, loginOrgId, returnMap, request, response);
    }

    private LoginStatus validateTenantor(String tenantId) {
        ITenantorService tenantorService = (ITenantorService)AppUtil.getBean(ITenantorService.class);
        Tenantor tenantor = tenantorService.getModeByTenantCode(tenantId);
        if (!tenantor.getIsEnabled()) {
            return LoginStatus.TenantNotFound;
        }
        if (DateUtil.compare((Date)tenantor.getEndTime(), (Date)DateUtil.getCurrentDate())) {
            return LoginStatus.TenantExpired;
        }
        return LoginStatus.Success;
    }

    private LoginStatus orgEngineSimulatedLogin(String tenantId, String userId, String account, String password, String loginOrgId, Map<String, Object> returnMap, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LoginStatus tenantStatus;
        if (StringUtil.isNullOrEmpty((String)account) && StringUtil.isNullOrEmpty((String)userId)) {
            throw new IllegalArgumentException("\u767b\u5f55\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        this._userName = account.trim();
        if (StringUtil.isNotEmpty((String)userId)) {
            this._userName = userId;
        }
        if (this.usersService == null) {
            this.usersService = AuthenticateHelper.getUsersService();
        }
        if (StringUtil.isNotEmpty((String)tenantId) && !tenantId.equalsIgnoreCase("BPM")) {
            ITenantorService tenantorService = (ITenantorService)AppUtil.getBean(ITenantorService.class);
            Tenantor tenantor = tenantorService.getModeByTenantCode(tenantId);
            if (tenantor == null || !tenantor.getIsEnabled()) {
                return LoginStatus.TenantNotFound;
            }
            if (DateUtil.compare((Date)tenantor.getEndTime(), (Date)DateUtil.getCurrentDate())) {
                return LoginStatus.TenantExpired;
            }
        }
        IUserService iUserService = AuthenticateHelper.getOrgImplUserService();
        LoginStatus status = LoginStatus.Unknown;
        IUser iuser = null;
        if (StringUtil.isNotEmpty((String)loginOrgId)) {
            iuser = StringUtil.isNotEmpty((String)userId) ? iUserService.getUserByIdOrgId(userId, loginOrgId) : iUserService.getUserByAccountOrgId(tenantId, account, loginOrgId);
        } else {
            IUser iUser = iuser = StringUtil.isNotEmpty((String)userId) ? iUserService.getUserById(userId) : iUserService.getUserByAccount(tenantId, account);
        }
        status = iuser == null ? LoginStatus.AccountNotFound : (iuser.getStatus() == 0 ? LoginStatus.AccountDisabled : (iuser.getStatus() == 99 ? LoginStatus.AccountDeleted : LoginStatus.Success));
        if (TenantUtil.getIsMultiTenant() && StringUtil.isEmpty((String)tenantId)) {
            tenantId = iuser.getTenantId();
        }
        if (TenantUtil.getIsMultiTenant() && StringUtil.isNotEmpty((String)tenantId) && !tenantId.equalsIgnoreCase("BPM") && !(tenantStatus = this.validateTenantor(tenantId)).equals((Object)LoginStatus.Success)) {
            return status;
        }
        if (status.equals((Object)LoginStatus.Success)) {
            String orgEngineSimulatedLoginFixPwd = AppConfig.getApp((String)"orgEngineSimulatedLoginFixPwd");
            if (!password.equalsIgnoreCase(nopassword) && !password.equalsIgnoreCase(orgEngineSimulatedLoginFixPwd)) {
                status = LoginStatus.InvalidPassword;
                return status;
            }
            LoginUser loginUser = new LoginUser(iuser);
            LoginUserCacheHelper.setUserCache((IUser)iuser);
            this._user = loginUser;
            HashMap<String, Object> getProperties = new HashMap<String, Object>();
            this._user.setProperties(getProperties);
            returnMap.put("tenantId", this._user.getTenantId());
            returnMap.put("userId", this._user.getUserId());
            returnMap.put("realName", this._user.getRealName());
            returnMap.put("orgId", this._user.getOrgId());
            returnMap.put("orgName", this._user.getOrgName());
            this.onLoginSuccess(new LoginEventArgs(status, "orgengine", tenantId, this._user.getUserId(), this._user.getAccount(), this._user.getRealName(), request, response));
        } else {
            this.onLoginFailure(new LoginEventArgs(status, "orgengine", tenantId, userId, this._userName, this._userName, request, response));
        }
        return status;
    }

    public boolean trustedLogin(String tenantId, String userName, Users user, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (StringUtil.isNullOrEmpty((String)userName)) {
            throw new IllegalArgumentException("\u767b\u5f55\u7528\u6237\u540d(userName)\u4e3a\u7a7a.");
        }
        this._userName = userName.trim();
        if (this.usersService == null) {
            this.usersService = AuthenticateHelper.getUsersService();
        }
        if (this.usersService != null) {
            user = this.usersService.getUserMasterOrgByUserName(userName, tenantId);
        }
        if (user != null) {
            this._user = new LoginUser(user);
            this.onLoginSuccess(new LoginEventArgs(LoginStatus.Success, "webform", this._userName, user.getRealName()));
            return true;
        }
        this.onLoginFailure(new LoginEventArgs(LoginStatus.Unknown, "webform", tenantId, this._userName));
        return false;
    }

    public List<Resource> getUserResourceListByUserId(String tenantId, String userId) {
        return AuthenticateHelper.getUserResourceListByUserId(tenantId, userId);
    }

    public Map<String, String> getUserResources(List<Resource> list) {
        if (CollectionUtil.isNullOrWhiteSpace(list)) {
            return null;
        }
        return AuthenticateHelper.getUserResources(list);
    }

    public void addLoginSuccessEvent(Object instObject, String methodName) {
        if (this.loginSuccessEvent == null) {
            this.loginSuccessEvent = new Delegator();
        }
        this.loginSuccessEvent.addEvent(instObject, methodName, new Class[]{LoginEventArgs.class});
    }

    protected void onLoginSuccess(LoginEventArgs e) throws Exception {
        if (this.loginSuccessEvent != null) {
            this.loginSuccessEvent.notifyAll(new Object[]{e});
        }
    }

    public void addLoginFailureEvent(Object instObject, String methodName) {
        if (this.loginFailureEvent == null) {
            this.loginFailureEvent = new Delegator();
        }
        this.loginFailureEvent.addEvent(instObject, methodName, new Class[]{LoginEventArgs.class});
    }

    protected void onLoginFailure(LoginEventArgs e) throws Exception {
        if (this.loginFailureEvent != null) {
            this.loginFailureEvent.notifyAll(new Object[]{e});
        }
    }
}

