/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.util.StringUtils;

public class PluginInfoContainer {
    private static Map<String, Set<String>> springRegisterBeanNames = new HashMap<String, Set<String>>();

    private PluginInfoContainer() {
    }

    public static synchronized void addRegisterBeanName(String pluginId, String beanName) {
        if (!StringUtils.isEmpty((Object)beanName)) {
            Set<String> beanNames = springRegisterBeanNames.get(pluginId);
            if (beanNames == null) {
                beanNames = new HashSet<String>();
                springRegisterBeanNames.put(pluginId, beanNames);
            }
            beanNames.add(beanName);
        }
    }

    public static synchronized void removeRegisterBeanName(String pluginId, String beanName) {
        Set<String> beanNames = springRegisterBeanNames.get(pluginId);
        if (beanNames != null) {
            beanNames.remove(beanName);
        }
    }

    public static synchronized boolean existRegisterBeanName(String pluginId, String beanName) {
        Set<String> beanNames = springRegisterBeanNames.get(pluginId);
        if (beanNames != null) {
            return beanNames.contains(beanName);
        }
        return false;
    }

    public static synchronized boolean existRegisterBeanName(String beanName) {
        for (Set<String> beanNames : springRegisterBeanNames.values()) {
            if (!beanNames.contains(beanName)) continue;
            return true;
        }
        return false;
    }
}

