/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration;

import com.gitee.starblues.integration.DefaultIntegrationConfiguration;
import java.util.Objects;
import org.pf4j.RuntimeMode;
import org.springframework.util.StringUtils;

public class ConfigurationBuilder
extends DefaultIntegrationConfiguration {
    private RuntimeMode runtimeMode = RuntimeMode.DEVELOPMENT;
    private String pluginPath = "";
    private String pluginConfigFilePath = "";
    private String uploadTempPath;
    private String backupPath;
    private String pluginRestControllerPathPrefix;
    private Boolean enablePluginIdRestControllerPathPrefix;

    public ConfigurationBuilder(Builder builder) {
        this.runtimeMode = Objects.requireNonNull(builder.runtimeMode, "runtimeMode can't be empty");
        this.pluginPath = Objects.requireNonNull(builder.pluginPath, "pluginPath can't be empty");
        this.pluginConfigFilePath = Objects.requireNonNull(builder.pluginConfigFilePath, "pluginConfigFilePath can't be empty");
        this.uploadTempPath = builder.uploadTempPath;
        this.backupPath = builder.backupPath;
        this.pluginRestControllerPathPrefix = builder.pluginRestControllerPathPrefix;
        this.enablePluginIdRestControllerPathPrefix = builder.enablePluginIdRestControllerPathPrefix;
    }

    public static Builder toBuilder() {
        return new Builder();
    }

    @Override
    public RuntimeMode environment() {
        return this.runtimeMode;
    }

    @Override
    public String pluginPath() {
        return this.pluginPath;
    }

    @Override
    public String pluginConfigFilePath() {
        return this.pluginConfigFilePath;
    }

    @Override
    public String uploadTempPath() {
        if (StringUtils.isEmpty((Object)this.uploadTempPath)) {
            return super.uploadTempPath();
        }
        return this.uploadTempPath;
    }

    @Override
    public String backupPath() {
        if (StringUtils.isEmpty((Object)this.backupPath)) {
            return super.backupPath();
        }
        return this.backupPath;
    }

    @Override
    public String pluginRestControllerPathPrefix() {
        if (StringUtils.isEmpty((Object)this.pluginRestControllerPathPrefix)) {
            return super.pluginRestControllerPathPrefix();
        }
        return this.pluginRestControllerPathPrefix;
    }

    @Override
    public boolean enablePluginIdRestControllerPathPrefix() {
        if (this.enablePluginIdRestControllerPathPrefix == null) {
            return super.enablePluginIdRestControllerPathPrefix();
        }
        return this.enablePluginIdRestControllerPathPrefix;
    }

    public static class Builder {
        private RuntimeMode runtimeMode = RuntimeMode.DEVELOPMENT;
        private String pluginPath = "";
        private String pluginConfigFilePath = "";
        private String uploadTempPath;
        private String backupPath;
        private String pluginRestControllerPathPrefix;
        private Boolean enablePluginIdRestControllerPathPrefix;

        public Builder runtimeMode(RuntimeMode runtimeMode) {
            this.runtimeMode = runtimeMode;
            return this;
        }

        public Builder pluginPath(String pluginPath) {
            this.pluginPath = pluginPath;
            return this;
        }

        public Builder pluginConfigFilePath(String pluginConfigFilePath) {
            this.pluginConfigFilePath = pluginConfigFilePath;
            return this;
        }

        public Builder uploadTempPath(String uploadTempPath) {
            this.uploadTempPath = uploadTempPath;
            return this;
        }

        public Builder backupPath(String backupPath) {
            this.backupPath = backupPath;
            return this;
        }

        public Builder pluginRestControllerPathPrefix(String pluginRestControllerPathPrefix) {
            this.pluginRestControllerPathPrefix = pluginRestControllerPathPrefix;
            return this;
        }

        public Builder enablePluginIdRestControllerPathPrefix(Boolean enablePluginIdRestControllerPathPrefix) {
            this.enablePluginIdRestControllerPathPrefix = enablePluginIdRestControllerPathPrefix;
            return this;
        }

        public ConfigurationBuilder build() {
            return new ConfigurationBuilder(this);
        }
    }
}

