/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.pf4j;

import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.integration.pf4j.Pf4jFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.pf4j.CompoundPluginRepository;
import org.pf4j.DefaultPluginManager;
import org.pf4j.JarPluginRepository;
import org.pf4j.PluginManager;
import org.pf4j.PluginRepository;
import org.pf4j.RuntimeMode;

public class DefaultPf4JFactory
implements Pf4jFactory {
    private final IntegrationConfiguration configuration;

    public DefaultPf4JFactory(IntegrationConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public PluginManager getPluginManager() {
        if (this.configuration == null) {
            throw new NullPointerException("IntegrationConfiguration is null");
        }
        RuntimeMode environment = this.configuration.environment();
        if (environment == null) {
            throw new RuntimeException("Configuration RuntimeMode is null" + this.configuration.environment());
        }
        if (RuntimeMode.DEVELOPMENT == environment) {
            Path path = Paths.get(this.getDevPluginDir(this.configuration), new String[0]);
            return new DefaultPluginManager(path){

                public RuntimeMode getRuntimeMode() {
                    System.setProperty("pf4j.mode", RuntimeMode.DEVELOPMENT.toString());
                    return RuntimeMode.DEVELOPMENT;
                }
            };
        }
        if (RuntimeMode.DEPLOYMENT == environment) {
            Path path = Paths.get(this.getProdPluginDir(this.configuration), new String[0]);
            return new DefaultPluginManager(path){

                protected PluginRepository createPluginRepository() {
                    return new CompoundPluginRepository().add((PluginRepository)new JarPluginRepository(this.getPluginsRoot()));
                }
            };
        }
        throw new RuntimeException("Not found run environment " + this.configuration.environment());
    }

    private String getDevPluginDir(IntegrationConfiguration configuration) {
        String pluginDir = configuration.pluginPath();
        if (Objects.equals("", pluginDir)) {
            pluginDir = "./plugins/";
        }
        return pluginDir;
    }

    private String getProdPluginDir(IntegrationConfiguration configuration) {
        String pluginDir = configuration.pluginPath();
        if (Objects.equals("", pluginDir)) {
            pluginDir = "plugins";
        }
        return pluginDir;
    }
}

