/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import com.gitee.starblues.utils.OrderPriority;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class CommonUtils {
    private CommonUtils() {
    }

    public static <T> List<T> order(List<T> list, Function<T, Integer> orderImpl) {
        if (list == null) {
            return list;
        }
        Collections.sort(list, Comparator.comparing(orderImpl, Comparator.nullsLast(Comparator.reverseOrder())));
        return list;
    }

    public static <T> Comparator<T> orderPriority(Function<T, OrderPriority> order) {
        return Comparator.comparing(t -> {
            OrderPriority orderPriority = (OrderPriority)order.apply(t);
            if (orderPriority == null) {
                orderPriority = OrderPriority.getLowPriority();
            }
            return orderPriority.getPriority();
        }, Comparator.nullsLast(Comparator.reverseOrder()));
    }
}

