/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import java.util.Optional;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpOAuth2Service;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpOauth2UserInfo;
import me.chanjar.weixin.cp.bean.WxCpUserDetail;
import me.chanjar.weixin.cp.bean.workbench.WxCpSecondVerificationInfo;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpOAuth2ServiceImpl
implements WxCpOAuth2Service {
    private final WxCpService mainService;

    @Override
    public String buildAuthorizationUrl(String state) {
        return this.buildAuthorizationUrl(this.mainService.getWxCpConfigStorage().getOauth2redirectUri(), state);
    }

    @Override
    public String buildAuthorizationUrl(String redirectUri, String state) {
        return this.buildAuthorizationUrl(redirectUri, state, "snsapi_base");
    }

    @Override
    public String buildAuthorizationUrl(String redirectUri, String state, String scope) {
        StringBuilder url = new StringBuilder("https://open.weixin.qq.com/connect/oauth2/authorize");
        url.append("?appid=").append(this.mainService.getWxCpConfigStorage().getCorpId());
        url.append("&redirect_uri=").append(URIUtil.encodeURIComponent((String)redirectUri));
        url.append("&response_type=code");
        url.append("&scope=").append(scope);
        if ("snsapi_privateinfo".equals(scope) || "snsapi_userinfo".equals(scope)) {
            url.append("&agentid=").append(this.mainService.getWxCpConfigStorage().getAgentId());
        }
        if (state != null) {
            url.append("&state=").append(state);
        }
        url.append("#wechat_redirect");
        return url.toString();
    }

    @Override
    public WxCpOauth2UserInfo getUserInfo(String code) throws WxErrorException {
        return this.getUserInfo(this.mainService.getWxCpConfigStorage().getAgentId(), code);
    }

    @Override
    public WxCpOauth2UserInfo getUserInfo(Integer agentId, String code) throws WxErrorException {
        String responseText = this.mainService.get(String.format(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/getuserinfo?code=%s&agentid=%d"), code, agentId), null);
        JsonObject jo = GsonParser.parse((String)responseText);
        return WxCpOauth2UserInfo.builder().userId(Optional.ofNullable(GsonHelper.getString((JsonObject)jo, (String)"UserId")).orElse(GsonHelper.getString((JsonObject)jo, (String)"userid"))).deviceId(GsonHelper.getString((JsonObject)jo, (String)"DeviceId")).openId(Optional.ofNullable(GsonHelper.getString((JsonObject)jo, (String)"OpenId")).orElse(GsonHelper.getString((JsonObject)jo, (String)"openid"))).userTicket(GsonHelper.getString((JsonObject)jo, (String)"user_ticket")).expiresIn(GsonHelper.getString((JsonObject)jo, (String)"expires_in")).externalUserId(GsonHelper.getString((JsonObject)jo, (String)"external_userid")).parentUserId(GsonHelper.getString((JsonObject)jo, (String)"parent_userid")).studentUserId(GsonHelper.getString((JsonObject)jo, (String)"student_userid")).build();
    }

    @Override
    public WxCpOauth2UserInfo getSchoolUserInfo(String code) throws WxErrorException {
        String responseText = this.mainService.get(String.format(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/getuserinfo?code=%s"), code), null);
        JsonObject jo = GsonParser.parse((String)responseText);
        return WxCpOauth2UserInfo.builder().deviceId(GsonHelper.getString((JsonObject)jo, (String)"DeviceId")).parentUserId(GsonHelper.getString((JsonObject)jo, (String)"parent_userid")).studentUserId(GsonHelper.getString((JsonObject)jo, (String)"student_userid")).build();
    }

    @Override
    public WxCpUserDetail getUserDetail(String userTicket) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("user_ticket", userTicket);
        String responseText = this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/auth/getuserdetail"), param.toString());
        return (WxCpUserDetail)WxCpGsonBuilder.create().fromJson(responseText, WxCpUserDetail.class);
    }

    @Override
    public WxCpOauth2UserInfo getAuthUserInfo(String code) throws WxErrorException {
        String responseText = this.mainService.get(String.format(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/auth/getuserinfo?code=%s"), code), null);
        JsonObject jo = GsonParser.parse((String)responseText);
        return WxCpOauth2UserInfo.builder().userId(GsonHelper.getString((JsonObject)jo, (String)"userid")).openId(GsonHelper.getString((JsonObject)jo, (String)"openid")).userTicket(GsonHelper.getString((JsonObject)jo, (String)"user_ticket")).externalUserId(GsonHelper.getString((JsonObject)jo, (String)"external_userid")).build();
    }

    @Override
    public WxCpSecondVerificationInfo getTfaInfo(String code) throws WxErrorException {
        String responseText = this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/auth/get_tfa_info"), GsonHelper.buildJsonObject((Object[])new Object[]{"code", code}));
        return (WxCpSecondVerificationInfo)WxCpGsonBuilder.create().fromJson(responseText, WxCpSecondVerificationInfo.class);
    }

    public WxCpOAuth2ServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

