/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.http.apache.ApacheBasicResponseHandler;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.impl.WxCpServiceApacheHttpClientImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class WxCpServiceImpl
extends WxCpServiceApacheHttpClientImpl {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        WxCpConfigStorage configStorage = this.getWxCpConfigStorage();
        if (!configStorage.isAccessTokenExpired() && !forceRefresh) {
            return configStorage.getAccessToken();
        }
        Lock lock = configStorage.getAccessTokenLock();
        lock.lock();
        try {
            if (!configStorage.isAccessTokenExpired() && !forceRefresh) {
                String string = configStorage.getAccessToken();
                return string;
            }
            String url = String.format(configStorage.getApiUrl("/cgi-bin/gettoken?corpid=%s&corpsecret=%s"), this.configStorage.getCorpId(), this.configStorage.getCorpSecret());
            try {
                String resultContent;
                WxError error;
                HttpGet httpGet = new HttpGet(url);
                if (this.getRequestHttpProxy() != null) {
                    RequestConfig config = RequestConfig.custom().setProxy(this.getRequestHttpProxy()).build();
                    httpGet.setConfig(config);
                }
                if ((error = WxError.fromJson((String)(resultContent = (String)this.getRequestHttpClient().execute((HttpUriRequest)httpGet, (ResponseHandler)ApacheBasicResponseHandler.INSTANCE)), (WxType)WxType.CP)).getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                configStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
            }
            catch (IOException e) {
                throw new WxRuntimeException((Throwable)e);
            }
        }
        finally {
            lock.unlock();
        }
        return configStorage.getAccessToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAgentJsapiTicket(boolean forceRefresh) throws WxErrorException {
        WxCpConfigStorage configStorage = this.getWxCpConfigStorage();
        if (forceRefresh) {
            configStorage.expireAgentJsapiTicket();
        }
        if (configStorage.isAgentJsapiTicketExpired()) {
            Lock lock = configStorage.getAgentJsapiTicketLock();
            lock.lock();
            try {
                if (configStorage.isAgentJsapiTicketExpired()) {
                    String responseContent = this.get(configStorage.getApiUrl("/cgi-bin/ticket/get?&type=agent_config"), null);
                    JsonObject jsonObject = GsonParser.parse((String)responseContent);
                    configStorage.updateAgentJsapiTicket(jsonObject.get("ticket").getAsString(), jsonObject.get("expires_in").getAsInt());
                }
            }
            finally {
                lock.unlock();
            }
        }
        return configStorage.getAgentJsapiTicket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        WxCpConfigStorage configStorage = this.getWxCpConfigStorage();
        if (forceRefresh) {
            configStorage.expireJsapiTicket();
        }
        if (configStorage.isJsapiTicketExpired()) {
            Lock lock = configStorage.getJsapiTicketLock();
            lock.lock();
            try {
                if (configStorage.isJsapiTicketExpired()) {
                    String responseContent = this.get(configStorage.getApiUrl("/cgi-bin/get_jsapi_ticket"), null);
                    JsonObject tmpJsonObject = GsonParser.parse((String)responseContent);
                    configStorage.updateJsapiTicket(tmpJsonObject.get("ticket").getAsString(), tmpJsonObject.get("expires_in").getAsInt());
                }
            }
            finally {
                lock.unlock();
            }
        }
        return configStorage.getJsapiTicket();
    }
}

