/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import jodd.http.net.SocketHttpConnectionProvider;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpClientType;
import me.chanjar.weixin.cp.api.impl.BaseWxCpServiceImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;

public class WxCpServiceJoddHttpImpl
extends BaseWxCpServiceImpl<HttpConnectionProvider, ProxyInfo> {
    private HttpConnectionProvider httpClient;
    private ProxyInfo httpProxy;

    public HttpConnectionProvider getRequestHttpClient() {
        return this.httpClient;
    }

    public ProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpClientType getRequestType() {
        return HttpClientType.JODD_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isAccessTokenExpired() && !forceRefresh) {
            return this.configStorage.getAccessToken();
        }
        Object object = this.globalAccessTokenRefreshLock;
        synchronized (object) {
            HttpRequest request = HttpRequest.get((String)String.format(this.configStorage.getApiUrl("/cgi-bin/gettoken?corpid=%s&corpsecret=%s"), this.configStorage.getCorpId(), this.configStorage.getCorpSecret()));
            if (this.httpProxy != null) {
                this.httpClient.useProxy(this.httpProxy);
            }
            request.withConnectionProvider(this.httpClient);
            HttpResponse response = request.send();
            String resultContent = response.bodyText();
            WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.CP);
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error);
            }
            WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
            this.configStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
        }
        return this.configStorage.getAccessToken();
    }

    @Override
    public void initHttp() {
        if (this.configStorage.getHttpProxyHost() != null && this.configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, this.configStorage.getHttpProxyHost(), this.configStorage.getHttpProxyPort(), this.configStorage.getHttpProxyUsername(), this.configStorage.getHttpProxyPassword());
        }
        this.httpClient = new SocketHttpConnectionProvider();
    }

    @Override
    public WxCpConfigStorage getWxCpConfigStorage() {
        return this.configStorage;
    }
}

