/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean.templatecard;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.List;
import me.chanjar.weixin.cp.bean.templatecard.TemplateCardButtonSelectionOption;
import org.apache.commons.lang3.StringUtils;

public class TemplateCardButtonSelection
implements Serializable {
    private String questionKey;
    private String title;
    private String selectedId;
    private List<TemplateCardButtonSelectionOption> optionList;

    public JsonObject toJson() {
        JsonObject btnObject = new JsonObject();
        if (StringUtils.isNotBlank((CharSequence)this.questionKey)) {
            btnObject.addProperty("question_key", this.questionKey);
        }
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            btnObject.addProperty("title", this.title);
        }
        if (StringUtils.isNotBlank((CharSequence)this.selectedId)) {
            btnObject.addProperty("selected_id", this.selectedId);
        }
        if (this.optionList != null && !this.optionList.isEmpty()) {
            JsonArray optionJsonArray = new JsonArray();
            for (TemplateCardButtonSelectionOption jump : this.getOptionList()) {
                JsonObject tempObject = jump.toJson();
                optionJsonArray.add((JsonElement)tempObject);
            }
            btnObject.add("option_list", (JsonElement)optionJsonArray);
        }
        return btnObject;
    }

    public static TemplateCardButtonSelectionBuilder builder() {
        return new TemplateCardButtonSelectionBuilder();
    }

    public String getQuestionKey() {
        return this.questionKey;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSelectedId() {
        return this.selectedId;
    }

    public List<TemplateCardButtonSelectionOption> getOptionList() {
        return this.optionList;
    }

    public void setQuestionKey(String questionKey) {
        this.questionKey = questionKey;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSelectedId(String selectedId) {
        this.selectedId = selectedId;
    }

    public void setOptionList(List<TemplateCardButtonSelectionOption> optionList) {
        this.optionList = optionList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateCardButtonSelection)) {
            return false;
        }
        TemplateCardButtonSelection other = (TemplateCardButtonSelection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$questionKey = this.getQuestionKey();
        String other$questionKey = other.getQuestionKey();
        if (this$questionKey == null ? other$questionKey != null : !this$questionKey.equals(other$questionKey)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$selectedId = this.getSelectedId();
        String other$selectedId = other.getSelectedId();
        if (this$selectedId == null ? other$selectedId != null : !this$selectedId.equals(other$selectedId)) {
            return false;
        }
        List<TemplateCardButtonSelectionOption> this$optionList = this.getOptionList();
        List<TemplateCardButtonSelectionOption> other$optionList = other.getOptionList();
        return !(this$optionList == null ? other$optionList != null : !((Object)this$optionList).equals(other$optionList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemplateCardButtonSelection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $questionKey = this.getQuestionKey();
        result = result * 59 + ($questionKey == null ? 43 : $questionKey.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $selectedId = this.getSelectedId();
        result = result * 59 + ($selectedId == null ? 43 : $selectedId.hashCode());
        List<TemplateCardButtonSelectionOption> $optionList = this.getOptionList();
        result = result * 59 + ($optionList == null ? 43 : ((Object)$optionList).hashCode());
        return result;
    }

    public String toString() {
        return "TemplateCardButtonSelection(questionKey=" + this.getQuestionKey() + ", title=" + this.getTitle() + ", selectedId=" + this.getSelectedId() + ", optionList=" + this.getOptionList() + ")";
    }

    public TemplateCardButtonSelection() {
    }

    public TemplateCardButtonSelection(String questionKey, String title, String selectedId, List<TemplateCardButtonSelectionOption> optionList) {
        this.questionKey = questionKey;
        this.title = title;
        this.selectedId = selectedId;
        this.optionList = optionList;
    }

    public static class TemplateCardButtonSelectionBuilder {
        private String questionKey;
        private String title;
        private String selectedId;
        private List<TemplateCardButtonSelectionOption> optionList;

        TemplateCardButtonSelectionBuilder() {
        }

        public TemplateCardButtonSelectionBuilder questionKey(String questionKey) {
            this.questionKey = questionKey;
            return this;
        }

        public TemplateCardButtonSelectionBuilder title(String title) {
            this.title = title;
            return this;
        }

        public TemplateCardButtonSelectionBuilder selectedId(String selectedId) {
            this.selectedId = selectedId;
            return this;
        }

        public TemplateCardButtonSelectionBuilder optionList(List<TemplateCardButtonSelectionOption> optionList) {
            this.optionList = optionList;
            return this;
        }

        public TemplateCardButtonSelection build() {
            return new TemplateCardButtonSelection(this.questionKey, this.title, this.selectedId, this.optionList);
        }

        public String toString() {
            return "TemplateCardButtonSelection.TemplateCardButtonSelectionBuilder(questionKey=" + this.questionKey + ", title=" + this.title + ", selectedId=" + this.selectedId + ", optionList=" + this.optionList + ")";
        }
    }
}

