/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.service.impl;

import com.google.gson.JsonObject;
import java.io.IOException;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.http.HttpClientType;
import me.chanjar.weixin.common.util.http.okhttp.DefaultOkHttpClientBuilder;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.tp.service.impl.BaseWxCpTpServiceImpl;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpTpServiceOkHttpImpl
extends BaseWxCpTpServiceImpl<OkHttpClient, OkHttpProxyInfo> {
    private static final Logger log = LoggerFactory.getLogger(WxCpTpServiceOkHttpImpl.class);
    private OkHttpClient httpClient;
    private OkHttpProxyInfo httpProxy;

    public OkHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public OkHttpProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpClientType getRequestType() {
        return HttpClientType.OK_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSuiteAccessToken(boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isSuiteAccessTokenExpired() && !forceRefresh) {
            return this.configStorage.getSuiteAccessToken();
        }
        Object object = this.globalSuiteAccessTokenRefreshLock;
        synchronized (object) {
            OkHttpClient client = this.getRequestHttpClient();
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("suite_id", this.configStorage.getSuiteId());
            jsonObject.addProperty("suite_secret", this.configStorage.getSuiteSecret());
            jsonObject.addProperty("suite_ticket", this.getSuiteTicket());
            String jsonBody = jsonObject.toString();
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)jsonBody);
            Request request = new Request.Builder().url(this.configStorage.getApiUrl("/cgi-bin/service/get_suite_token")).post(requestBody).build();
            String resultContent = null;
            try (Response response = client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected response code: " + response);
                }
                resultContent = response.body().string();
            }
            catch (IOException e) {
                log.error("\u83b7\u53d6 suite token \u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                throw new WxRuntimeException("\u83b7\u53d6 suite token \u5931\u8d25", (Throwable)e);
            }
            WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.CP);
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error);
            }
            jsonObject = GsonParser.parse((String)resultContent);
            String suiteAccussToken = jsonObject.get("suite_access_token").getAsString();
            int expiresIn = jsonObject.get("expires_in").getAsInt();
            this.configStorage.updateSuiteAccessToken(suiteAccussToken, expiresIn);
        }
        return this.configStorage.getSuiteAccessToken();
    }

    @Override
    public void initHttp() {
        log.debug("WxCpServiceOkHttpImpl initHttp");
        if (this.configStorage.getHttpProxyHost() != null && this.configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = OkHttpProxyInfo.httpProxy((String)this.configStorage.getHttpProxyHost(), (int)this.configStorage.getHttpProxyPort(), (String)this.configStorage.getHttpProxyUsername(), (String)this.configStorage.getHttpProxyPassword());
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            clientBuilder.proxy(this.getRequestHttpProxy().getProxy());
            clientBuilder.authenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)WxCpTpServiceOkHttpImpl.this.httpProxy.getProxyUsername(), (String)WxCpTpServiceOkHttpImpl.this.httpProxy.getProxyPassword());
                    return response.request().newBuilder().header("Authorization", credential).build();
                }
            });
            this.httpClient = clientBuilder.build();
        } else {
            this.httpClient = DefaultOkHttpClientBuilder.get().build();
        }
    }
}

